package it.softecspa.kahuna.hibernate;

import it.softecspa.kahuna.log.KLogger;

import java.util.List;

import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;

public class KQuery {
	
	static KLogger log = KLogger.getLogger("org.hibernate.SQL");

	/**
	 * Restituisce un unico risultato evitando errori in caso in cui in lista siano presenti pi risultati
	 * @param query
	 * @return
	 */
	public static Object uniqueResult(SQLQuery sqlquery) {
		return getFirst(sqlquery.list());	
	}
		
	@SuppressWarnings("rawtypes")
	public static List list(SQLQuery sqlquery) {
		return sqlquery.list();		
	}
	
	
	
	/**
	 * Restituisce un unico risultato evitando errori in caso in cui in lista siano presenti pi risultati
	 * @param query
	 * @return
	 */
	public static Object uniqueResult(Query query) {
		return getFirst(query.list());		
	}
	
	@SuppressWarnings("rawtypes")
	public static List list(Query query) {
		return query.list();		
	}
	
	
	/**
	 * Restituisce un unico risultato evitando errori in caso in cui in lista siano presenti pi risultati
	 * @param criteria
	 * @return
	 */
	public static Object uniqueResult(Criteria criteria) {
		return getFirst(criteria.list());		
	}
	
	
	
	@SuppressWarnings("rawtypes")
	private static Object getFirst(List list) {
		if (list==null || list.size()==0) return null;
		if (list.size()>1) log.debug("Extract not unique result ("+list.size()+">1), acquired the first");
		return list.get(0);	
	}
	
}
