package it.softecspa.kahuna.hibernate;

import it.softecspa.kahuna.log.KLogger;

import org.hibernate.Session;
import org.hibernate.Transaction;

public class KSession {

	static KLogger log = KLogger.getLogger("org.hibernate.SQL");
	static boolean autoclear = true;
	
	
	
	public static void close(Session session) {
		close(session, log);
	}
	
	/**
	 * Chiude la sessione eseguendo se necessario un rollback sulla transazione
	 * @param session
	 * @param log
	 */
	public static void close(Session session, KLogger log) {
		if (session==null) return;
		
		Transaction transaction = session.getTransaction(); 
		if (transaction!=null &&
			transaction.isActive()) {
			log.warn("Close session with transaction security controls, automatic rollback");
			transaction.rollback();
			// Pulizia della sessione di sicurezza
			if (autoclear) session.clear();
		}
		
		session.close();
		if (log.isTraceEnabled()) log.trace("Opened session is closed");
		session=null;		
	}
	
	
	/**
	 * Esegue un  rollback della transazione eventualmente aperta sulla sessione
	 * @param session
	 * @return true se  stata eseguito il rollback correttamente
	 */
	public static boolean rollback(Session session) {
		return rollback(session, log);
	}
	
	public static boolean rollback(Session session, KLogger log) {
		if (session==null) return false;
		
		Transaction transaction = session.getTransaction();
		if (transaction!=null &&
		    transaction.isActive()) {
			log.debug("Execute rollback!");
			transaction.rollback();
			
			// Pulizia della sessione di sicurezza
			if (autoclear) session.clear();
			return true;
		}
		return false;
	}
	
	
	/**
	 * Esegue il commit della transazione eventulmente aperta
	 * @param session
	 * @return  true se  stata eseguita la commit correttamente
	 */
	public static boolean commit(Session session) {
		return commit(session, log);
	}
	
	public static boolean commit(Session session, KLogger log) {
		if (session==null) {
			log.warn("Required 'commit' without valid session");
			return false;
		}
		
		Transaction transaction = session.getTransaction();
		if (transaction==null ||
			!transaction.isActive()) {
			log.warn("Required 'commit' without begin transaction first");
			return false;
		}
		
		session.flush();
		if (transaction!=null &&
			transaction.isActive()) {
			log.debug("Execute commit!");
			transaction.commit();
			
			// Pulizia della sessione di sicurezza
			if (autoclear) session.clear();
			return true;
		}	
		return false;
	}
	
	
	
}
