package it.softecspa.kahuna.io.ftp.remoteFile;

import java.util.Date;


public class FileAttrs {

  private String flags = "";
  private boolean directory=false;
  private boolean hidden=false;
  private long size;
  
  private int inode;

  private int groupID;
  private int userID;
  
  private long modificationTime; // modification time

  private int perms;
  private boolean symbolicLink;

        
  public FileAttrs() {    
  }

  /**
   * Determines the file's permissions and flags.
   * The first column of the directory listing contains the permissions in
   * unix like operating systems. This method parses this column to obtain
   * the permission as a numeric value. Also finds out if we are looking at
   * a directory.
   *
   * @param s
   * @return
   */
  public boolean parseFlags(String s) {
    flags = s;
	directory = (s.charAt(0) == 'd');
    symbolicLink = (s.charAt(0) == 'l');

	perms = (s.charAt(1) == 'r') ? perms | 4 : perms;
	perms = (s.charAt(2) == 'w') ? perms | 2 : perms;
	perms = (s.charAt(3) == 'x') ? perms | 1 : perms;
	perms <<=3;

	perms = (s.charAt(4) == 'r') ? perms | 4 : perms;
	perms = (s.charAt(5) == 'w') ? perms | 2 : perms;
	perms = (s.charAt(6) == 'x') ? perms | 1 : perms;
	perms <<=3;

	perms = (s.charAt(7) == 'r') ? perms | 4 : perms;
	perms = (s.charAt(8) == 'w') ? perms | 2 : perms;
	perms = (s.charAt(9) == 'x') ? perms | 1 : perms;

	return true;
  }

  
  public boolean isDirectory() {
    return directory;
  }
    
  public void setDirectory(boolean valore) {
    directory = valore;
  }

  
  public boolean isHidden() {
    return hidden;
  }
  
  public void setHidden(boolean valore) {
    hidden=valore;
  }
  
  
  public long getSize() {
    return size;
  }

  protected void setSize(long valore) {
    size=valore;
  }

  
  public int getUserID() {
    return userID;
  }
  
  protected void setUserID(int i) {
    userID=i;
  }
  

  public int getGroupID() {
    return groupID;
  }
  
  protected void setGroupID(int i) {
    groupID=i;
  }
  
  
  public Date getTime() {
  	return new Date(modificationTime);
  }

  protected void setTime(long valore) {
    modificationTime=valore;
  }

  
  public String getFlags() {
	return flags;
  }
  
  
  public int getInode() {
  	return inode;
  }
  
  protected void setInode(int i) {
    inode=1;
  }
	
  
  public int getPerms() {
  	return perms;
  }

  public boolean isSymLink() {
	return symbolicLink;
  }



  
}