package it.softecspa.kahuna.io.ftp.remoteFile;


import it.softecspa.kahuna.io.ftp.FTPConnection;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;



public class MSRemoteFile extends RemoteFile {

  public MSRemoteFile() {
    super(FTPConnection.MICROSOFT);    
  }
  
  /**
   * Creates the new instance based by parsing the data provided in the
   * input string.
   */
  public MSRemoteFile(String s) {
    super(FTPConnection.MICROSOFT);
    attrs = new FileAttrs();
	
	/*
	 * the order of the parts are
	 * date time <dir> size filename
	 * mm-dd-yy hh:mm(AM/PM)
	 */

	/* is this is a directory */
	if(s.substring(24,29).equals("<DIR>")) {
	  attrs.setDirectory(true);
	} else {
      /*
       *the file size in bytes, in windows a file size is
       * not assigned to directories
       */
      String num = s.substring(30,39);
      if(num == null) num ="0";
      try {
      	attrs.setSize(Long.parseLong(num.trim()));
      } catch (Exception e) {
      	return;
      }
    }

	String dateTime ="";

	/* grab the date and time (first two columns) */
	dateTime = s.substring(0,9) + s.substring(10,17);
	SimpleDateFormat dateFormat = new SimpleDateFormat("MM-DD-yy HH:mm");
	try {
	  Date date =  dateFormat.parse(dateTime);
	  attrs.setTime(date.getTime());
	} catch (ParseException e) {
	  //ex.printStackTrace();
	}

	/* grab the file name */
	fileName = s.substring(39,s.length());
  }

}