package it.softecspa.kahuna.io.ftp.remoteFile;

import it.softecspa.kahuna.lang.XString;

import java.util.StringTokenizer;


public class Path {
  
  private String directory = "";
  private String nome = "";
  
  public Path(String path) {
    if (path!=null) {
      path=path.trim();
      path = XString.replaceAll(path,"\\","/");      
    
      StringTokenizer st = new StringTokenizer(path,"/");      
      for (int i=0;st.countTokens()>1;i++) {
        if (i==0 && path.startsWith("/")) directory +="/";
        directory += (String)st.nextToken()+"/";
      }
      nome = (String)st.nextToken();
    }
  }
  
  public String getName() {
    return nome;
  }
  
  public String getDirectory() {
    return directory;
  }
  
  public String getPath() {
    return directory+nome;
  }
}
