package it.softecspa.kahuna.io.ftp.remoteFile;


/**
 * <p>Represents a file on the remote server, two subclasses provide functionality
 * specific to files on windows and unix like operating systems. Other platforms
 * are not supported at the moment.</p>
 * <p>The correct way to make use of this class is to create a new instance
 * by calling the {@link #parse parse()} method, which is a factory.
 * </p>
 *
 *
 * @author Raditha Dissanayake
 * @version 1.01
 */

public class RemoteFile implements Comparable<String> {
  private int server = 0;

  String fileName="sconosciuto";
  String filePath=null;
  FileAttrs attrs = null;
  
  
  protected RemoteFile(int serverType) {
    server = serverType;
  }

  
  /**
   * A factory method that creates a remote file instanace for the current
   * server type.
   *
   * @param s a line read in from the LIST command.
   * @return an instance of a RemoteFile subclass.
   */
  public static RemoteFile parse(String s,int server) {
    RemoteFile f=null;

    if (server==it.softecspa.kahuna.io.ftp.FTPConnection.MICROSOFT) {
      f = new MSRemoteFile(s);
      if(f.getName() == null) {
        /*
         * that famous copy cat, can be configured to produce a
         * unix like directory listing.
         */
        try {
          f = new UnixRemoteFile(s);
        } catch (Exception ex) {
          /*
           * aw, shucks it's a malformed entry after all :-)
           */
          return null;
        }
      }
    } else {
      if(!s.startsWith("total")) {
        f = new UnixRemoteFile(s);
      }
    }
    return (f==null || f.getName()==null)? null:f;
  }

  
  /**
   * Create an entry for the parent folder.
   *
   * The ftp server maynot return a '..' entry, in that case we have to
   * create one, however doing a ls ../.. is not always a good idea so
   * we hack together a filename.
   *
   * @return an object that corresponds to the parent folder of the current
   *  working directory.
   */
  public static RemoteFile doubleDot(int server) {
    RemoteFile f=null;
    if (server==it.softecspa.kahuna.io.ftp.FTPConnection.MICROSOFT) {
      f = new MSRemoteFile();
    } else {
      f = new UnixRemoteFile();
    }
    f.setName("..");
    FileAttrs at = new FileAttrs();
    at.setDirectory(true);
    f.setAttrs(at);
    return f;
  }


  public String getName() {
	return fileName;
  }

  public String getPath() {
    return filePath;
  }

  
  
  public FileAttrs getAttrs() {
	return attrs;
  }

  
  protected void setAttrs(FileAttrs attrs) {
  	this.attrs = attrs;
  }

  
  public void setName(String valore) {
  	fileName = valore;
  }

  public void setPath(String valore) {
    Path local = new Path(valore);
    
    filePath = local.getPath();
    if (!local.getName().equals(fileName)) {
      fileName = local.getName();
    }
  }
  
  
  
  public boolean isDirectory() {
    return attrs.isDirectory();
  }

  
  public boolean isHidden() {
    return attrs.isHidden();
  }
  

  public int compareTo(String paragone) {
    return this.toString().compareTo(paragone.toString());    
  }
  
  public String toString() {
    return fileName;
  }

  
  public int getServerType() {
    return this.server;
  }


}
