package it.softecspa.kahuna.io.ftp.remoteFile;

import it.softecspa.kahuna.io.ftp.FTPConnection;
import it.softecspa.kahuna.log.NLoggerManager;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


public class UnixRemoteFile extends RemoteFile {

  /**
   * This defaults constructor with package access is inteded for use by
   * the RemoteFile class.
   */
  UnixRemoteFile() {
    super(FTPConnection.UNIX);
  }

  /**
   * Creates a new instance by parsing the data given.
   * @param s a line that was read in after executing the LIST command.
   */
  
  public UnixRemoteFile(String s) {
    super(FTPConnection.UNIX);

    /*
	 * the order of the parts are
	 * flags, inode, uid, gid, size,  month, day, time, name
	 */	
	String[] parts = s.split(" ");
	/*
	 * splitting by ' ' is actually a bit tricky because the filename
	 * might contain spaces as well. If this happens we will have more
	 * than 9 elements that we bargained for.
	 *
	 * A Second complication is the fact that often there is more than
	 * one space character between two elements. Hence the need for us
	 * to have two different iterators i and j.
	 */
	EnterpriseCalendar cal = new EnterpriseCalendar();
	String dateTime ="";

	if(parts.length < 8) {
	  // this entry is malfored or it's the summary.	   
      fileName=null;
      return;
	}
    
	for (int i = 0, j=0 ; i < parts.length; i++) {
	  if(parts[i].trim().equals("")) continue;
		
	  switch(j) {
		case 0: attrs = new FileAttrs();
			attrs.parseFlags(parts[i]);
			break;
		case 1:
          try {
          	attrs.setInode(Integer.parseInt(parts[i]));
          }
          catch (NumberFormatException ex) {
          	attrs.setInode(0);
          }
          break;

		case 2:
          /*
           * wu-ftpd sends the username instead of the uid at times.
           */
          try {
          	attrs.setUserID(Integer.parseInt(parts[i]));
          } catch (NumberFormatException ex) {
          	attrs.setUserID(0);
          }
          break;

		case 3:
          try {
          	attrs.setGroupID(Integer.parseInt(parts[i]));
          } catch (NumberFormatException ex) {
          	attrs.setGroupID(0);
          }
          break;

		case 4: 
          attrs.setSize(Long.parseLong(parts[i]));
          break;

		case 5:
		  if (parts[i+2].indexOf(":") != -1) {
			/* time given assume current year */
		  }
		
        case 6: 
          dateTime += parts[i] + " ";
		  break;		
        case 7: 
          dateTime += parts[i];
          try {
      			if(parts[i].indexOf(":") != -1)	{
      			  // DateFormat dateFormat = DateFormat.getDateTimeInstance();      			  
      			  SimpleDateFormat dateFormat =	new SimpleDateFormat("yyyy MMM dd HH:mm");
              dateTime = cal.get(Calendar.YEAR) + " " + dateTime;   
              //dateTime = dateTime.substring(0,17);
              Date date =  dateFormat.parse(dateTime);
      			  attrs.setTime(date.getTime());
      			  
      			} else {
      			  SimpleDateFormat dateFormat =	new SimpleDateFormat("MMM dd yyyy");
      			  Date date =  dateFormat.parse(dateTime);
      			  attrs.setTime(date.getTime());
      			}
          }	catch (Exception e) {
      			NLoggerManager.livelloError("unparsable data for " + s,e);
      	  }
        break;

		case 8:
          fileName = (parts[i] == null) ? "" : parts[i];
	      break;

		case 9:
		  /*
           * We are here probably because the filename has spaces
           * in it (there are only nine fields in the list, since
           * we start counting from zero this is the tenth).
           *
           * If the file name does have spaces it could be a
           * symlink.
           */
		  if(i> 8) {
			while(i < parts.length)	{
			  if (attrs.isSymLink() && parts[i].trim().equals("->"))	{
				/*
	  			 * what follows is the 'other' file name which
				 * we do not want.
				 */
				i++;
				break;
			  }
			  this.fileName += " " + parts[i++];
			}
		  }
		  break;

		default:
		 break;
	  }
	  j++;
	}
	
    fileName = fileName.trim();
    attrs.setHidden(fileName.startsWith(".") &&
                    !fileName.equals(".") && 
                    !fileName.equals(".."));
  }
  
}