package it.softecspa.kahuna.io.sftp;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.log.NLoggerManager;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.HostKey;
import com.jcraft.jsch.HostKeyRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;

public class SFTP  {


  public static class MyUserInfo implements UserInfo {
    
    public String getPassword() { return null; }
    
    public boolean promptYesNo(String str) {
      NLoggerManager.livelloWarning("[MyYserInfo] " + XString.replaceAll(str, "\n", " ") + " Yes");
      return true;
    }
    
    public String getPassphrase() { return null; }
    public boolean promptPassphrase(String message) { return true; }
    public boolean promptPassword(String message) { return false; }
    public void showMessage(String message) { }
    
  }
  
  private int PRIMARY = 0;
  private int SECONDARY = 1;
  
  JSch jsch;
  Session session;
  ChannelSftp[] sftp;
  
  int timeout;
  String knowhosts;
  HostKey key;
  
  
  public SFTP() {
    jsch = new JSch();
    sftp = new ChannelSftp[2]; 
  }
  
  
  public boolean openConnection(String host,int port, String user, String password, int timeout) throws SFTPException {
  
    
    NLoggerManager.livelloDebug("[SFTP] Attempting to connect...");
    try {
      session = jsch.getSession(user, host, port);
    } catch (JSchException e) {
      throw new SFTPException(e);
    }
    
    if (session==null) return false;
    
    UserInfo ui = new MyUserInfo();
    session.setUserInfo(ui);
    
    session.setPassword(password);  // Valorizza la password per la connessione

    /* Nota:
     * Per fare la connessione devo essere in possesso di una chiave pubblica,
     * che per posso non aver ancora memorizzzato ma che il server mi pu dare
     * Oppure utilizzo la chiave pubblic ache risiede sul client e/o che mi sono
     * memorizzato in precedenza
     * Faccio quindi la verifica in 2 fasi 
     */
    
    /* 1) Cerco la chiave nell'elenco sul client
     * 1b) oppure la forzo perch presente nel file di configurazione
       2) Se presente la utilizzo per fare la chiamata al server
          a) se va in errore esco e consiglio di controllare e/o ripulire la chiave
          b) ...vado avanti!
       3) Se la chiave non  presente faccio una chiamata senza chiave e me ne faccio ritornare una dal server
       4) Memorizzo la chiave ottenuta per la riconnessione successiva       
    
    */ 
    
    
    if (key!=null) {
      // Aggiungo la chiave custom al repository delle chivi 
      HostKeyRepository hostKeyRepository = jsch.getHostKeyRepository();
      hostKeyRepository.add(key, ui);
    }
    
    
    if (knowhosts!=null) {
      try {
        jsch.setKnownHosts(knowhosts);
      } catch (JSchException e) {
        throw new SFTPException(e);
      }
      
      if (key==null) {
        // Cerco la chiave nell'elenco sul client sul file
        HostKeyRepository hkr = jsch.getHostKeyRepository();
        HostKey[] hostKeys = hkr.getHostKey();
        if (hostKeys!=null) {
          for (int i=0; i<hostKeys.length; i++){
            HostKey hk = hostKeys[i];
            if (hk.getHost().equals(host)) {
              key=hk;
              NLoggerManager.livelloInfo("[SFTP] Trovata chiave "+hk.getType()+" per l'host "+hk.getHost()+" nel file "+knowhosts);
              NLoggerManager.livelloDebug("[knowhosts] "+hk.getHost()+" "+hk.getType()+" "+hk.getKey());
              NLoggerManager.livelloDebug("[key] "+key.getKey());
            }
          }
        }
      }
    }
    
    if (key==null) {
      JSch.setConfig("StrictHostKeyChecking", "no"); // Nessun check della chiave
      NLoggerManager.livelloDebug("[SFTP] Logging in without RSA key...");
    } else {
      JSch.setConfig("StrictHostKeyChecking", "yes"); // Chiave presente nel file
      
      
      
      
      
      NLoggerManager.livelloDebug("[SFTP] Logging in with RSA key fingerprint "+key.getFingerPrint(jsch));
    }  
    try {
      this.timeout = timeout;
      session.connect(timeout);
    } catch (JSchException e) {
      throw new SFTPException(e);
    } 
  
    openChannel(PRIMARY);
    return true;
  }


  

  private ChannelSftp openChannel(int index) throws SFTPException {
    NLoggerManager.livelloDebug("[SFTP] Session starting...");
    if (session==null) {
      throw new SFTPException("Sesssion null");
    }
    
    Channel channel = null;      
    try {
      NLoggerManager.livelloDebug("[SFTP] Opening channel "+index+"...");
      channel = session.openChannel("sftp");
      channel.connect(timeout);      
    } catch (JSchException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
    NLoggerManager.livelloDebug("[SFTP,2] Session "+index+" started!");
    sftp[index] = (ChannelSftp)channel;  
    return sftp[index];
  }
  
  
  
  
  

  public String getKnowhosts() {
    return knowhosts;
  }

  public void setKnowHosts(String knowhosts) {
    this.knowhosts = knowhosts;
  }
  
 

  public HostKey getHostKey() {
    return key;
  }

  public void setHostKey(HostKey key) {
    this.key = key;
  }

  
  
  public boolean cd(String path) {
    try {
      NLoggerManager.livelloDebug("sftp> cd "+path);
      sftp[PRIMARY].cd(path);
      return true;
      
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      return false;
    }
  }


  @SuppressWarnings("unchecked")
	public List<String> ls(String path) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> ls "+path);
      return (List<String>)sftp[PRIMARY].ls(path);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }  
  
  
  
  
  public void put(InputStream fis, String nome) throws SFTPException {
    put(fis, nome, ChannelSftp.OVERWRITE);
  }
  
  public void put_append(InputStream fis, String nome) throws SFTPException {
    put(fis, nome, ChannelSftp.APPEND);
  }
  
  public void put_resume(InputStream fis, String nome) throws SFTPException {
    put(fis, nome, ChannelSftp.RESUME);
  }
  
  public void put(InputStream fis, String nome, int mode) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> put "+nome);
      sftp[PRIMARY].put(fis, nome, mode);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }
  
  
  
  
  
  public void get(String nome, OutputStream fos) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> get "+nome);
      sftp[PRIMARY].get(nome, fos);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }
  
  
  
  
  /**
   * Rinomina il file situato sul server remoto
   * @param oldpath
   * @param newpath
   * @see SFTP#move(String, String)
   * @throws SFTPException
   * 
   */
  public void rename(String oldpath, String newpath) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> rename "+oldpath+" "+newpath);
      sftp[PRIMARY].rename(oldpath, newpath);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }
  
  
  
  /**
   * Effettua una copia del file sul erver remoto
   * @param vecchio
   * @param nuovo
   * @throws SFTPException
   */
  public void copy(String vecchio, String nuovo) throws SFTPException {
    NLoggerManager.livelloDebug("sftp> copy "+vecchio+" "+nuovo);
    
    // Apro un secondo canale
    if (sftp[SECONDARY]==null) openChannel(SECONDARY);
    
    NLoggerManager.livelloDebug("[SFTP] Copy in progress...");
    InputStream fis = null;
    try {
      try {
        fis = sftp[PRIMARY].get(vecchio);         
      } catch (SftpException e) {
        NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
        throw new SFTPException(e);
      }
      
      try {
        sftp[SECONDARY].put(fis, nuovo);        
      } catch (SftpException e) {
        NLoggerManager.livelloError("[SFTP,2] "+(e.getMessage()!=null?e.getMessage():e.toString()));
        throw new SFTPException(e);
      }
      
    } finally {        
      try {
        if (fis!=null) fis.close();
      } catch (IOException e) {
        NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
        throw new SFTPException(e);
      }
    }

  }
  
  /**
   * Sposta il file dalla posizione A alla posizione B sul server remoto
   * @param source
   * @param target
   * @see SFTP#rename(String, String)
   * @throws SFTPException
   */
  public void move(String source, String target) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> move "+source+" "+target);
      sftp[PRIMARY].rename(source, target);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    } 
  }
  
  
  
  
  public void quit(int index) {
    if (sftp==null) return;
    if (sftp[index]!=null) {
      NLoggerManager.livelloDebug("sftp> quit "+index);
      sftp[index].quit();
    }
  }
  
  public void quit() {
    if (sftp==null) return;
    
    NLoggerManager.livelloDebug("sftp> quit");
    // Chiudo tutte le connessioni aperte
    for (int i=0; i<sftp.length; i++) {
      if (sftp[i]!=null) sftp[i].quit();
    }    
  }

  public void close() {
    quit();
  }  
  
  

  protected Session getSession() {
    return session;
  }


  public JSch getJsch() {
    return jsch;
  }


  protected ChannelSftp getSftp() {
    return sftp[PRIMARY];
  }

  protected ChannelSftp getSftp(int index) {
    return sftp[index];
  }
  

  public String pwd() throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> pwd");
      return sftp[PRIMARY].pwd();
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }
  
  public String lpwd() {
    NLoggerManager.livelloDebug("sftp> lpwd");
    return sftp[PRIMARY].lpwd();
  }


  public boolean exists(String path) {
    try {
      NLoggerManager.livelloDebug("sftp> exists "+path);
      SftpATTRS attributi = sftp[PRIMARY].stat(path);  
      return (attributi!=null);    
    } catch (SftpException e) {
      return false;      
    }
  }
  
  
  public SftpATTRS stat(String path) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> stat "+path);
      return sftp[PRIMARY].stat(path);
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);    
    }
  }


  public void delete(String path) throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> rm "+path);
      sftp[PRIMARY].rm(path);      
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }


  public String getHome() throws SFTPException {
    try {
      NLoggerManager.livelloDebug("sftp> home");
      return sftp[PRIMARY].getHome();
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      throw new SFTPException(e);
    }
  }
  
  
  public String getServerVersion() {
    try {
      NLoggerManager.livelloDebug("sftp> version");
      return "SFTP server version "+sftp[PRIMARY].getServerVersion();
    } catch (SftpException e) {
      NLoggerManager.livelloError("[SFTP] "+(e.getMessage()!=null?e.getMessage():e.toString()));
      return "SFTP server version ancknown";
    }
  }











  


  
  

  
}
