package it.softecspa.kahuna.lang;

import it.softecspa.kahuna.util.XOR;
import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

import java.io.StringReader;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

@SuppressWarnings("serial")
public class XString implements java.io.Serializable {

	String value = null;

	public XString(String value) {
		this.value = value;
	}

	public XString(Integer value) {
		this.value = (value != null ? value.toString() : null);
	}

	public XString(int value) {
		this(new Integer(value));
	}

	public XString(Long value) {
		this.value = (value != null ? value.toString() : null);
	}

	public XString(long value) {
		this(new Long(value));
	}

	public XString(Object oggetto) {
		this.value = XString.toString(oggetto, "");
	}

	public XString(boolean value) {
		this.value = "" + value;
	}

	public void set(String value) {
		this.value = value;
	}

	/**
	 * Funzione di conversione stringa
	 * 
	 * @param oggetto
	 * @param valore
	 * @return String
	 */
	public static String toString(Object oggetto, String value) {
		if (oggetto==null) return value;
		
		if (oggetto.getClass().isArray()) {
		  Object[] elenco = (Object[])oggetto;
		  String s="";
		  for (Object elemento: elenco) {
			  if (!s.equals("")) s+=",";
			  s+=toString(elemento,value);			  
		  }
		  return s;
		  
		} else if (oggetto instanceof EnterpriseCalendar) {
			return ((EnterpriseCalendar)oggetto).toStringUTC();
		} else if (oggetto instanceof Calendar) {
			return EnterpriseCalendar.newInstance((Calendar)oggetto).toStringUTC();
		} else if (oggetto instanceof List<?>) {
			String s="";
			  for (Object elemento: (List<?>)oggetto) {
				  if (!s.equals("")) s+=",";
				  s+=toString(elemento,value);			  
			  }
			  return s;
		} else {
			return (oggetto != null ? oggetto.toString() : value);
		}
	}

	public static String toString(Object oggetto) {
		return XString.toString(oggetto, "");
	}

	public static String toString(EnterpriseCalendar calendario) {
		return (calendario != null ? calendario.toStringUTC() : "");
	}
	
	public static String toStringBetweenApex(Object value) {
		if (value==null) return "";
		return "'" + value.toString() + "'";		
	}
	
	public String toString() {
		return value;
	}

	public void replaceAll(String ricerca, String sostituisci) {
		value = XString.replaceAll(value, ricerca, sostituisci);
	}

	public static String replaceAll(String stringa, String ricerca, String sostituisci) {
		if (stringa != null && stringa.indexOf(ricerca) >= 0) {
			int s = 0;
			int e = 0;
			StringBuffer appoggio = new StringBuffer();

			while ((e = stringa.indexOf(ricerca, s)) >= 0) {
				appoggio.append(stringa.substring(s, e));
				appoggio.append(sostituisci);
				s = e + ricerca.length();
			}
			appoggio.append(stringa.substring(s));
			return appoggio.toString();

		}
		return stringa;
	}

	public String fillerLeft(String filler, int n) {
		String appoggio = value;
		if (appoggio == null)
			appoggio = "";
		for (int i = appoggio.length(); i < n; i++) {
			appoggio = filler + appoggio;
		}
		return appoggio;
	}

	public String fillerLeft(char carattere, int n) {
		return fillerLeft(new Character(carattere).toString(), n);
	}

	public static String fillerLeft(String stringa, String filler, int n) {
		XString s = new XString(stringa);
		return s.fillerLeft(filler, n);
	}

	public static String fillerLeft(String stringa, char carattere, int n) {
		XString s = new XString(stringa);
		return s.fillerLeft(carattere, n);
	}

	public String fillerRight(String filler, int n) {
		String appoggio = value;
		if (appoggio == null)
			appoggio = "";
		for (int i = appoggio.length(); i < n; i++) {
			appoggio = appoggio + filler;
		}
		return appoggio;
	}

	public String fillerRight(char c, int n) {
		return fillerRight(new Character(c).toString(), n);
	}

	public static String fillerRight(String stringa, String filler, int n) {
		XString s = new XString(stringa);
		return s.fillerRight(filler, n);
	}

	public static String fillerRight(String stringa, char carattere, int n) {
		XString s = new XString(stringa);
		return s.fillerRight(carattere, n);
	}

	public String fillerZero(int n) {
		return fillerLeft("0", n);
	}

	public static String fillerZero(String stringa, int size) {
		if (stringa == null)
			return "";
		return fillerLeft(stringa, "0", size);
	}

	public static String fillerZero(int i, int size) {
		return fillerLeft(Integer.toString(i), "0", size);
	}

	public static String fillerZero(long l, int size) {
		return fillerLeft(Long.toString(l), "0", size);
	}

	public static String fillerZero(Integer i, int size) {
		if (i == null)
			return "";
		return fillerLeft(i.toString(), "0", size);
	}

	public String fillerSpaceLeft(int size) {
		return fillerLeft(" ", size);
	}

	public static String fillerSpaceLeft(String stringa, int size) {
		return fillerLeft(stringa, " ", size);
	}

	public static String fillerSpaceRight(String stringa, int size) {
		return fillerRight(stringa, " ", size);
	}

	public String fillerSpaceRight(int size) {
		return fillerRight(" ", size);
	}

	public static String space(int size) {
		return fillerRight("", " ", size);
	}

	public static String zero(int size) {
		return fillerZero("", size);
	}

	public static String formatNumber(long valore, int decimali) {
		return formatNumber(new Double(valore), decimali);
	}

	public static String formatNumber(long valore) {
		return formatNumber(new Double(valore));
	}

	public static String formatNumber(double valore, int decimali) {
		return formatNumber(new Double(valore), decimali);
	}

	public static String formatNumber(double valore) {
		return formatNumber(new Double(valore));
	}

	public static String formatNumber(String value, int decimali) {
		if (value != null && !value.trim().equals("")) {
			Double d = new Double(value);
			return formatNumber(d, decimali);
		} else {
			return formatNumber(new Double(0.0), decimali);
		}
	}

	public static String formatNumber(String value) {
		if (value != null && !value.trim().equals("")) {
			Double d = new Double(value);
			return formatNumber(d);
		} else {
			return formatNumber(new Double(0.0));
		}
	}

	
	public static String formatNumber(Object valore, int decimali, Locale locale) {
		if (valore == null)	return "";

		NumberFormat nf = NumberFormat.getInstance(locale);
		nf.setMaximumFractionDigits(decimali);
		nf.setMinimumFractionDigits(decimali);
		return nf.format(valore);
	}
	
	public static String formatNumber(Object valore, int decimali) {
		return formatNumber(valore, decimali, Locale.ITALIAN);
	}

	
	
	public static String formatNumber(Object valore, Locale locale) {
		if (valore == null)	return "";

		NumberFormat nf = NumberFormat.getInstance(locale);
		return nf.format(valore);
	}
	
	
	public static String formatNumber(Object valore) {
		return formatNumber(valore, Locale.ITALIAN);
	}

	
	
	public static String formatCalendar(EnterpriseCalendar value, String formato) {
		if (value==null) return "";
		return value.format(formato);
	}
	
	public static String formatCalendar(Calendar value, String formato) {
		return formatCalendar(EnterpriseCalendar.newInstance(value), formato);
	}
	
	public static String formatCalendar(Calendar value) {
		return formatCalendar(value, "dd/MM/yyyy HH:mm.ss");
	}
	
	
	
	public static String formatByte(long valore) {
		long K = 1024;
		long M = K * K;
		long G = M * K;
		long T = G * K;

		if (valore / T == 0) {
			if (valore / G == 0) {
				if (valore / M == 0) {
					if (valore / K == 0) {
						return formatNumber(valore, 0) + " B";
					} else {
						return formatNumber(valore / K, 0) + " KB";
					}
				} else {
					return formatNumber(valore / M, 0) + " MB";
				}
			} else {
				return formatNumber(valore / G, 0) + " GB";
			}
		} else {
			return formatNumber(valore / T, 0) + " TB";
		}
	}

	/**
	 * Sostituisce il carattere apice (') con (\') per l'utilizzo con Javascript
	 * @deprecated Use {@link #apexHTML()} instead
	 */
	public String apiceHTML() {
		return apexHTML();
	}

	/**
	 * Sostituisce il carattere apice (') con (\') per l'utilizzo con Javascript
	 */
	public String apexHTML() {
		if (this.isNotBlankNull()) {
			return XString.replaceAll(value, "'", "\'");
			/*
			 * String appoggio = stringa; int i=0; while (appoggio.indexOf("'",
			 * i)>=0) { //System.out.println(s + " - " + i + " - " +
			 * s.length()); i=appoggio.indexOf("'", i)+2;
			 * appoggio=appoggio.substring(0,i-2) + "\\" +
			 * appoggio.substring(i-2); if (i>=appoggio.length()) return
			 * appoggio; }
			 */
		}
		return "";
	}

	/**
	 * Sostituisce il carattere slash (\) con (\\) per l'utilizzo con Javascript
	 */
	public String slashHTML() {
		if (this.isNotBlankNull()) {
			return XString.replaceAll(value, "\\", "\\\\");
			/*
			 * String appoggio = stringa;
			 * 
			 * int i=0; while (appoggio.indexOf("\\", i)>=0) {
			 * //System.out.println(s + " - " + i + " - " + s.length());
			 * i=appoggio.indexOf("\\", i)+2; appoggio=appoggio.substring(0,i-2)
			 * + "\\" + appoggio.substring(i-2); if (i>=appoggio.length())
			 * return appoggio; }
			 */
		}
		return "";
	}

	
	
	/**
	 * Toglie i TAG html da una stringa
	 * 
	 * @param valore
	 * @return il contenuto del tag
	 */
	public static String extractTAG(String stringa) {
		if (isNotBlankNull(stringa)) {
			boolean continua = true;
			String appoggio = stringa;
			while (continua) {
				int i = appoggio.indexOf("<");
				if (i >= 0) {
					int f = appoggio.indexOf(">", i + 1);
					appoggio = appoggio.substring(0, i) + appoggio.substring(f + 1);
				} else {
					continua = false;
				}
			}
			return appoggio;
		}
		return "";
	}

	/**
	 * Toglie i TAG html da una stringa
	 * 
	 * @return
	 */
	public String estraiTAG() {
		return extractTAG(value);
	}

	/**
	 * Formatta la stringa come un CHAR oracle di lunghezza specificata
	 * 
	 * @param valore
	 * @param lunghezza
	 * @return
	 */
	public static String toCHAR(String value, int lunghezza) {
		if (value == null)
			return null;
		if (value.length() >= lunghezza)
			return value;
		String appoggio = value;
		for (int i = value.length(); i < lunghezza; i++) {
			appoggio += " ";
		}
		return appoggio;
	}

	/**
	 * Confronta le due stringhe e ne verifica l'uguaglianza
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static boolean equals(String value1, String value2) {
		if (value1 == null)
			return (value2 == null);
		return value1.equals(value2);
	}

	/**
	 * Confronta le due stringhe e ne verifica l'uguaglianza ignorando maiuscole
	 * e minuscole
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static boolean equalsIgnoreCase(String value1, String value2) {
		if (value1 == null)
			return (value2 == null);
		return value1.equalsIgnoreCase(value2);
	}

	/**
	 * Confronta le due stringhe e ne verifica l'uguaglianza ignorando gli spazi
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static boolean equalsTrim(String value1, String value2) {
		if (value1 == null)
			return (value2 == null);
		if (value2 == null)
			return false;
		return value1.trim().equals(value2.trim());
	}

	/**
	 * Confronta le due stringhe e ne verifica l'uguaglianza ignorando maiuscole
	 * e minuscole e gli eventuali spazi
	 * 
	 * @param value1
	 * @param value2
	 * @return
	 */
	public static boolean equalsIgnoreCaseTrim(String value1, String value2) {
		if (value1 == null)
			return (value2 == null);
		if (value2 == null)
			return false;
		return value1.trim().equalsIgnoreCase(value2.trim());
	}

	public static String removeEscapeCharacters(String stringa) {
		/*
		 * &#060; less than sign < &#062; greater than sign > &#064; at sign @
		 * &#091; left bracket [ &#093; right bracket ] &#096; back apostrophe `
		 * &#123; left curly brace { &#124 vertical bar | &#125; right curly
		 * brace } &#126; tilde ~ &#133; ellipsis  &#134 dagger  &#135; double
		 * dagger  &#145; left single quote  &#146; right single quote 
		 * &#147; left double quote  &#148; right double quote  &#149; bullet
		 *  &#150; short dash  &#151; longer dash  &#153; trademark  &#161;
		 * inverted excallamation point  &#162; cent sign  &#163; pound sign 
		 * &#165; yen sign  &#166; broken vertical bar  &#169; copyright sign
		 *  &#171; double left than sign  &#172; logical not sign  &#174;
		 * registered trademark sign  &#176; degree sign  &#177; plus or minus
		 * sign  &#178; superscript 2  &#179; superscript 3  &#185;
		 * superscript 1  &#187; double greather than sign  &#188; fraction
		 * 1/4  &#189; fraction 1/2  &#190; fraction 3/4  &#191; inverted
		 * question mark  &#247; division sign  &#8220; left double quote 
		 * &#8221; right double quote  &#8212; dash 
		 */

		String s = stringa;
		boolean continua = true;
		while (continua) {
			int i = s.indexOf("&");

			if (i >= 0) {
				int f = s.indexOf(";", i + 1);

				String appoggio = s.substring(0, i) + s.substring(f + 1);
				s = appoggio;
			} else {
				continua = false;
			}
		}
		return s;
	}

	/**
	 * Funzione creata per la varifica della validit delle stringhe
	 * 
	 * @param valore
	 * @return true se la stringa  NOT NULL e diversa da stringa vuota
	 */
	public boolean isNull() {
		return (value == null);
	}

	public boolean isNotNull() {
		return (value != null);
	}

	public boolean isBlankNull() {
		return !isNotBlankNull();
	}

	public boolean isNotBlankNull() {
		return isNotBlankNull(value);
	}

	public boolean isNotBlankNullTrim() {
		return isNotBlankNullTrim(value);
	}
	
	public static boolean isBlankNull(String stringa) {
		return !isNotBlankNull(stringa);
	}

	public static boolean isNotBlankNull(String stringa) {
		return (stringa != null && !stringa.equals(""));
	}

	public static boolean isBlankNullTrim(String stringa) {
		return !isNotBlankNullTrim(stringa);
	}

	public static boolean isNotBlankNullTrim(String stringa) {
		return (stringa != null && !stringa.trim().equals(""));
	}

	public boolean isNotNullEquals(String confronto) {
		return (value != null && value.equals(confronto));
	}

	public boolean isNotNullEqualsIgnoreCase(String confronto) {
		return (value != null && value.equalsIgnoreCase(confronto));
	}

	/**
	 * Funzione di conversione stringa
	 * 
	 * @param oggetto
	 * @return String
	 */
	public String toStringBR() {
		if (this.isNotBlankNull()) {
			String appoggio = XString.replaceAll(this.value, "\n", "<BR>");
			return XString.replaceAll(appoggio, "\r", "");
		}
		return "";
	}

	public String toTooltip(String apice, String sostituisci) {
		if (this.isNotBlankNull()) {
			String appoggio = XString.replaceAll(this.value, apice, sostituisci);
			appoggio = XString.replaceAll(appoggio, "\n", "<BR>");
			return XString.replaceAll(appoggio, "\r", "");
		}
		return "";
	}

	public String toTooltip() {
		return toTooltip("'", "&acute;");
	}

	/*
	 * private String[] toArray() { String[] caratteri = null; // Attenzione il
	 * metodo split  dalla versione 1.4 o superiori try { caratteri =
	 * valore.split(); } catch(NoSuchMethodError e) { StringTokenizer st = new
	 * StringTokenizer(indirizzo,ADDRESS_SEPARATOR); caratteri = new
	 * String[st.countTokens()]; int i=0; while (st.hasMoreTokens()) {
	 * indirizzi[i++]= st.nextToken(); } }
	 * 
	 * // Se richiesta faccio la verifica if (verifica) { for (int
	 * i=0;i<indirizzi.length;i++) { controllaIndirizzo(indirizzi[i]); } }
	 * return indirizzi; }
	 */

	public int count(String ricerca) {
		if (value == null)
			return 0;
		if (ricerca == null)
			return 0;

		byte[] scomposizione = value.getBytes();
		byte r = ricerca.getBytes()[0];

		int conta = 0;
		for (int i = 0; i < scomposizione.length; i++) {
			conta += (scomposizione[i] == r ? 1 : 0);
		}

		return conta;
	}

	public String toLowerCase() {
		return value.toLowerCase();
	}

	public String toUpperCase() {
		return value.toUpperCase();
	}

	
	public String toUpperCaseFirst() {
		return XString.toUpperCaseFirst(value);
	}

	
	public static String toUpperCaseFirst(String value) {
		if (value == null)
			return null;
		if (value.length() <= 1)
			return value.toUpperCase();
		// return
		// valore.substring(0,1).toUpperCase()+valore.substring(1).toLowerCase();
		return value.substring(0, 1).toUpperCase() + value.substring(1);
	}

	
	
	public String capitalizeString() {
		return XString.capitalizeString(value);
	}
	
	public static String capitalizeString(String string) {
		char[] chars = string.toLowerCase().toCharArray();
		boolean found = false;
		for (int i = 0; i < chars.length; i++) {
			if (!found && Character.isLetter(chars[i])) {
				chars[i] = Character.toUpperCase(chars[i]);
				found = true;
			} else if (Character.isWhitespace(chars[i]) || chars[i] == '.' || chars[i] == '\'') { 
				// You can add other chars here
				found = false;
			}
		}
		return String.valueOf(chars);
	}
	
	public String toLowerCaseFirst() {
		return XString.toLowerCaseFirst(value);
	}
	
	public static String toLowerCaseFirst(String value) {
		if (value == null)
			return null;
		if (value.length() <= 1)
			return value.toLowerCase();
		return value.substring(0, 1).toLowerCase() + value.substring(1);
	}
	
	
	/**
	 * Restituisce vero se l'oggetto XString contiene parti del confronto
	 * 
	 * @param confronto
	 * @return
	 * @deprecated Use {@link #contains(String)} instead
	 */
	public boolean contiene(String confronto) {
		return contains(confronto);
	}

	/**
	 * Restituisce vero se l'oggetto XString contiene parti del confronto
	 * 
	 * @param confronto
	 * @return
	 */
	public boolean contains(String confronto) {
		return XString.contains(value, confronto);
	}

	/**
	 * @deprecated Use {@link #contains(String,String)} instead
	 */
	public static boolean contiene(String value, String confronto) {
		return contains(value, confronto);
	}

	public static boolean contains(String value, String confronto) {
		boolean trovato = false;
		if (XString.isNotBlankNull(value)) {
			for (int i = 0; i <= value.length() && !trovato; i++) {
				for (int k = 0; k < value.length() && !trovato; k++) {
					trovato = (value.charAt(i) == value.charAt(k));
				}
			}
		}
		return trovato;
	}

	public int indexOf(String value) {
		return value.indexOf(value);
	}

	/*
	 * Sostituisce il carattere apice (') con (\') per l'HTML
	 
	public static String apiceHTML(String s) {
		if (s != null) {
			int i = 0;
			while (s.indexOf("'", i) >= 0) {
				// System.out.println(s + " - " + i + " - " + s.length());
				i = s.indexOf("'", i) + 2;
				s = s.substring(0, i - 2) + "\\" + s.substring(i - 2);
				if (i >= s.length())
					return s;
			}
		}
		return s;
	}
	*/

	/*
	 * Sostituisce il carattere slash (\) con (\\) per HTMP
	 * 
	 * @param s
	 * @return
	public static String slashHTML(String s) {
		if (s != null) {
			int i = 0;
			while (s.indexOf("\\", i) >= 0) {
				// System.out.println(s + " - " + i + " - " + s.length());
				i = s.indexOf("\\", i) + 2;
				s = s.substring(0, i - 2) + "\\" + s.substring(i - 2);
				if (i >= s.length())
					return s;
			}
		}
		return s;
	}
	*/

	/*
	 * Sostituisce il carattere apice (') e slash (\) con le rispettive
	 * codifiche escape per l'HTML
	public static String escapeHTML(String s) {
		s = slashHTML(s);
		s = apiceHTML(s);
		return s;
	}
	*/

	public static String nullZERO(String value) {
		return (value != null ? value : "0");
	}

	public static String nullONE(String value) {
		return (value != null ? value : "1");
	}

	public static String nullBLANK(String value) {
		return (value != null ? value : "");
	}

	public static String nullSPACE(String value) {
		return (value != null ? value : " ");
	}

	public static String nullValue(String value, String nullValue) {
		return (value != null ? value : nullValue);
	}

	/**
	 * Restituisce la sottostrigna a partire da sinistra della lunghezza
	 * desiderata Se la dimensione  un valore negativo questo viene sottratto
	 * alla dimensione della stringa
	 * 
	 * @param valore
	 * @param size
	 * @return
	 */
	public static String left(String value, int size) {
		if (value == null)	return null;
		if (size > 0) {
			if (size < value.length())
				return value.substring(0, size);
		}
		if (size < 0) {
			if (-size < value.length())
				return value.substring(0, value.length() + size);
		}
		return value;
	}

	/**
	 * Restituisce la sottostrigna a partire da destra della lunghezza
	 * desiderata Se la dimensione  un valore negativo il valore viene
	 * calcolato a partire dall'inizio della stringa
	 * 
	 * @param valore
	 * @param dimensione
	 * @return
	 */
	public static String right(String value, int size) {
		if (value == null)	return null;
		if (size > 0) {
			if (size < value.length())
				return value.substring(value.length() - size);
		}
		if (size < 0) {
			if (-size < value.length())
				return value.substring(-size);
		}
		return value;
	}

	
	public static String trim(String value) {
		if (value == null)	return null;
		return value.trim();
	}

	public static String cut(String value, int size) {
		if (value==null) return null;		
		if (value.length()>size) return value.substring(0,size);
		return value;
	}
	
	public static String prettyXML(String input) throws Exception {
       return prettyXML(input, false);
    }
	
	public static String prettyXML(String input, boolean omit_xml_declaration) throws Exception {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {transformerFactory.setAttribute("indent-number", new Integer(2)); } catch (Exception e){}
        
        Transformer transformer = transformerFactory.newTransformer();
        try {transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2"); } catch (Exception e){}
        transformer.setOutputProperty(OutputKeys.INDENT , "yes");
        if (omit_xml_declaration) transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");
        StringWriter writer = new StringWriter();
        transformer.transform(new StreamSource(new StringReader(input)), new StreamResult(writer));
        String prexml = writer.toString();
        
        // Workaround per problema di indentazione testata XML
        if (prexml.contains("?><")) {
        	if (prexml.contains("\r\n")) {
        		return replaceAll(prexml, "?><","?>\r\n<");
        	} else {
        		return replaceAll(prexml, "?><","?>\n<");
        	}
        }
        return prexml;
    }
	
	
	
	
	/**
	 * Verifica ed effettua le sostituzioni all'interno della stringa con il valore recuperato dalle configurazioni di sistema
	 * @param source
	 * @return
	 */
	public static String replaceSystemProperty(String source) {
		return replaceSystemProperty(source,0);
	}
	
	private static String replaceSystemProperty(String source, int start) {
		int p1 = source.indexOf("${",start);
		if (p1<0) return source;
	
		int p2 = source.indexOf("}",p1);
		if (p2<0) return source;
		
		// Variabile da sostituire
		String value = source.substring(p1,p2+1);
		String key = source.substring(p1+2,p2);
		String newValue = System.getProperty(key);		
		source = XString.replaceAll(source, value, newValue);
		
		// ...verifico se ci sono altre variabili da cambiare
		return replaceSystemProperty(source, p2);
	}
	
	
	public static String convertFromUnicode(String source) {
		String target = "";
		do {
			int i = source.indexOf("%");
			if (i<0) break;
			if (source.length()-i<3) break;
			
			String value=source.substring(i+1,i+3);
			try {
				byte[] b = XOR.hex2byte(value);
				target += source.substring(0,i)+(char)b[0];
				source = source.substring(i+3);
			} catch (ParseException e) {
				// Valore non valido, concateno e passo al ciclo successivo
				target += source.substring(0,i+1);
				continue;
			}
			
		} while(true);
		target += source;	
		
		
		return target;
	}
	
	public static Integer parseInteger(String value) {
		if (isBlankNull(value)) return (Integer)null;
		if ("null".equalsIgnoreCase(value)) return (Integer)null;
		return Integer.parseInt(value);
	}
	
	public static Long parseLong(String value) {
		if (isBlankNull(value)) return (Long)null;
		if ("null".equalsIgnoreCase(value)) return (Long)null;
		return Long.parseLong(value);
	}
}