package it.softecspa.kahuna.lang.exception;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;


@SuppressWarnings("serial")
public class ConfigurationException extends Exception {

  private List<String> errori;
  
  public ConfigurationException(String messaggio) {
    super(messaggio);
    errori = new ArrayList<String>(1);
    errori.add(messaggio); 
    
  }

  public ConfigurationException(Exception e) {
    super(e);
    errori = new ArrayList<String>(1);
    errori.add(e.getMessage()!=null?e.getMessage():e.toString());    
  }

  public ConfigurationException(List<String> errori) {
    super("Multiples error!");
    this.errori = errori;
  }

  
  public List<String> getErrori() {
    return errori;
  }
  
 
  public void printStackTrace(PrintWriter s) {
    printStackTrace(s, false);
  }
    
  private void printStackTrace(PrintWriter s, boolean header) {
    synchronized (s) {
      s.println(this);
      for (int i=0; i<errori.size(); i++) {
        Object errore = errori.get(i);
        if (ConfigurationException.class.isInstance(errore)) {
          ConfigurationException e = (ConfigurationException)errore;
          e.printStackTrace(s);
        } else if (Exception.class.isInstance(errore)) {
          Exception e = (Exception)errore;
          s.println("\tcaused by " + (e.getMessage()!=null?e.getMessage():e.toString()));
        } else if (String.class.isInstance(errore)) {
          s.println("\tcaused by " + (String)errore);
        } else {
          s.println("\tcaused by " + errore.toString());
        }
      }     
    }
  }
    
  public void printStackTrace(PrintStream s) {
    printStackTrace(s, false);
  }
    
  private void printStackTrace(PrintStream s, boolean header) {
    synchronized (s) {
      if (header )s.println(this);
      for (int i=0; i < errori.size(); i++) {
        Object errore = errori.get(i);
        if (ConfigurationException.class.isInstance(errore)) {
          ConfigurationException e = (ConfigurationException)errore;
          e.printStackTrace(s, false);
        } else if (Exception.class.isInstance(errore)) {
          Exception e = (Exception)errore;
          s.println("\tcaused by " + (e.getMessage()!=null?e.getMessage():e.toString()));
        } else if (String.class.isInstance(errore)) {
          s.println("\tcaused by " + (String)errore);
        } else {
          s.println("\tcaused by " + errore.toString());
        }
      }      
    }
  }
  
  
  public void setErrori(List<String> errori) {
    this.errori = errori;
  }
  
}
