package it.softecspa.kahuna.lang.exception;




public class KException {
  
  Throwable e;
  
  public KException (Throwable e) {
    this.e = e;
  }
  
  
  public String toString() {
    return e!=null?e.toString():"";
    /*
    String s = e.getClass().getName();
    String message = e.getLocalizedMessage();
    return (message != null) ? (s + ": " + message) : s;
    */
  }
  
  /**
   * Provides programmatic access to the stack trace information printed by
   * {@link #stringStackTrace()}.  Returns a string of stack trace elements,
   * each representing one stack frame.  
   * 
   * @return a string of stack trace elements representing the stack trace
   *         pertaining to this throwable.
   */
  public String stringStackTrace() {
	String s = this + "\n";
    StackTraceElement[] trace = e.getStackTrace();
    for (int i=0; i < trace.length; i++) s+="\tat " + trace[i]+"\n";

    Throwable ourCause = e.getCause();
    if (ourCause != null) {
      KException ec = new KException(ourCause);   
      s+= ec.stringStackTraceAsCause(trace);
    }
    return s;
  }
  
  
  String stringStackTraceAsCause(StackTraceElement[] causedTrace) {
    // assert Thread.holdsLock(s);
    String s = "";
    
    // Compute number of frames in common between this and caused
    StackTraceElement[] trace = e.getStackTrace();
    int m = trace.length-1, n = causedTrace.length-1;
    while (m >= 0 && n >=0 && trace[m].equals(causedTrace[n])) {
      m--; n--;
    }
    int framesInCommon = trace.length - 1 - m;
    
    s+= "Caused by: " + this + "\n";
    for (int i=0; i <= m; i++) s+= "\tat " + trace[i] +"\n";
    if (framesInCommon != 0) s+= "\t... " + framesInCommon + " more" +"\n";
    
    // Recurse if we have a cause
    Throwable ourCause = e.getCause();
    if (ourCause != null) {
      KException ec = new KException(ourCause);   
      s+= ec.stringStackTraceAsCause(trace);
    }
    
    return s;
  }


  
  public Throwable getException() {
    return e;
  }
  
  
  
}  
