package it.softecspa.kahuna.lang.exception;




@SuppressWarnings("serial")
public abstract class KThrowable extends Throwable {
  
  
  /**
   * Provides programmatic access to the stack trace information printed by
   * {@link #printStackTrace()}.  Returns a string of stack trace elements,
   * each representing one stack frame.  
   * 
   * @return a string of stack trace elements representing the stack trace
   *         pertaining to this throwable.
   */
  public String stringStackTrace() {
    String s = this + "\n";
    StackTraceElement[] trace = getStackTrace();
    for (int i=0; i < trace.length; i++) s+="\tat " + trace[i]+"\n";

    Throwable ourCause = getCause();
    if (ourCause != null) {
      KException ec = new KException(ourCause);   
      s+= ec.stringStackTraceAsCause(trace);
    }
    return s;
  }
  
  
  
}  
