package it.softecspa.kahuna.log;

import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.lang.exception.ConfigurationException;
import it.softecspa.kahuna.sql.Sql;
import it.softecspa.kahuna.util.Properties;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.LogLog;

/** @deprecated */
public class NLog {

	// Variabile globale utilizzata per il log
	private Logger logger;
	private boolean ticketable;

	/**
	 * Restituisce uan istanza di NLog a partire da un logger
	 * 
	 * @param logger
	 */
	public NLog(Logger logger) {
		this(logger, false);
	}

	/**
	 * Restituisce uan istanza di NLog a partire da un logger E' configurato il ticket
	 * 
	 * @param logger
	 */
	public NLog(Logger logger, boolean ticket) {
		this.logger = logger;
		this.ticketable = ticket;
	}

	/**
	 * Restituisce uan istanza di NLog a partire da un'altra istanza di NLog
	 * 
	 * @param log
	 */
	public NLog(NLog log) {
		this(log != null ? log.getLogger() : null);
	}

	protected static String key(String prefix, String suffix) {
		return prefix == null ? suffix : prefix + "." + suffix;
	}

	public static NLog getInstanceAutoconfig(Properties prop, String prefix) {
		/*
		 * Elenco parametri di configurazione Debug.LOG_LEVEL Debug.LOG_PATH Debug.LOG_FILENAME Debug.LOG_EXT Debug.LOG_REALM Debug.LOG_CONSOLE
		 * 
		 * Debug.LOG_FLUSH Debug.LOG_CYCLE Debug.LOG_SIZE
		 * 
		 * Debug.LOG_LAYOUT_CONVERSIONE_PATTERN
		 */
		if (prefix != null && prefix.endsWith("."))
			prefix = prefix.substring(0, prefix.length() - 1);

		List<String> errori = new ArrayList<String>();

		// Livello di debug
		String livello = prop.get(key(prefix, NLoggerManager.LOG_LEVEL), NLoggerManager.getLevel().toString());

		String realm = prop.get(key(prefix, NLoggerManager.LOG_REALM), prefix + ".NLog.class");

		String path = prop.get(key(prefix, NLoggerManager.LOG_PATH), NLoggerManager.getPath());
		if (path == null)
			errori.add("Mandatory parameter absent: " + key(prefix, NLoggerManager.LOG_PATH));

		// Prefisso del nome del file
		String filename = prop.get(key(prefix, NLoggerManager.LOG_FILENAME), NLoggerManager.getFilename());
		if (filename == null)
			errori.add("Mandatory parameter absent: " + key(prefix, NLoggerManager.LOG_FILENAME));

		String ext = prop.get(key(prefix, NLoggerManager.LOG_EXT), NLoggerManager.getExt());
		if (ext == null)
			ext = ".log";

		// Formattazione del layout del log
		String pattern_string = prop.get(key(prefix, NLoggerManager.LOG_LAYOUT_CONVERSIONE_PATTERN));
		if (pattern_string == null)
			pattern_string = "%d %-5p %c - %m%n";

		// Caricamento valore di flush del log
		int autoflush = prop.getInt(key(prefix, NLoggerManager.LOG_FLUSH), -1);
		// Caricamento cycle e autosize
		int cycle = prop.getInt(key(prefix, NLoggerManager.LOG_CYCLE), -1);
		String size = prop.get(key(prefix, NLoggerManager.LOG_SIZE));
		int bufferSize = 0;

		int type = NLoggerManager.DATED_FILE;
		if (cycle <= 0) {
			// Considero il log giornaliero {AUTOFLUSH}
			type = NLoggerManager.DATED_FILE;

			if (autoflush < 0) {
				String msg = "Optional parameter absent: " + key(prefix, NLoggerManager.LOG_FLUSH) + ", default = 0";
				LogLog.warn(msg);
				autoflush = 0;
				prop.put(key(prefix, NLoggerManager.LOG_FLUSH), autoflush);
			}

		} else {
			// Considero il log ciclico {CYCLE,SIZE}
			type = NLoggerManager.ROLLING_FILE;

			if (size == null) {
				size = "100K";
				prop.put(key(prefix, NLoggerManager.LOG_SIZE), size);
			}
			try {
				bufferSize = Integer.parseInt(size.substring(0, size.length() - 1));
				String b = size.substring(size.length() - 1);
				if (b.equalsIgnoreCase("K")) {
					bufferSize = bufferSize * 1024;
				} else if (b.equalsIgnoreCase("M")) {
					bufferSize = bufferSize * 1024 * 1024;
				} else {
					bufferSize = bufferSize * 1024;
				}
			} catch (Exception e) {
				errori.add("Value is not valid for parameter: " + key(prefix, NLoggerManager.LOG_SIZE) + " (K,M)");
			}
		}

		if (errori.size() > 0) {
			ConfigurationException e = new ConfigurationException(errori);
			LogLog.error("Error configuring NLog(Properties,\"" + prefix + "\")", e);
			return null;
		}

		// Razionalizzazione del path
		path = File.rationalizePath(path);
		prop.put(key(prefix, NLoggerManager.LOG_PATH), path);

		if (type == NLoggerManager.DATED_FILE) {
			if (!filename.endsWith("."))
				filename += ".";
		}
		if (ext.endsWith("."))
			ext += "log";
		if (ext.indexOf(".") < 0)
			ext = "." + ext;
		if (NLoggerManager.getBase() != null)
			path = NLoggerManager.getBase() + path;

		// Caricamento del ROOT logger
		Logger logger = Logger.getLogger(realm);
		logger.setAdditivity(false); /*
									 * Nota: impostando a FALSE il metodo setAdditivity() gli appendere non vengono inseriti a livello di root
									 */
		logger.setLevel(Level.toLevel(livello));

		Layout layout = new PatternLayout(pattern_string);
		if (type == NLoggerManager.DATED_FILE) {
			// Creo l'istanza di DatedFileAppender e aggiungo l'appender
			DatedFileAppender dfAppender = new DatedFileAppender(path, filename, ext, autoflush);
			dfAppender.setLayout(layout);
			dfAppender.setName(realm);
			logger.addAppender(dfAppender);

		} else if (type == NLoggerManager.ROLLING_FILE) {
			// Creo una istanza di RollingFileAppender e aggiungo l'appendere
			RollingFileAppender rfAppender;
			try {
				rfAppender = new RollingFileAppender(layout, path + filename + ext);
			} catch (IOException e) {
				NLoggerManager.livelloError("Error configuring NLog(PropertiesPlus,\"" + prefix + "\")", e);
				return new NLog(NLoggerManager.getLogger());
			}
			// rfAppender.setFile(path+filename+ext);
			// rfAppender.setLayout(layout);
			rfAppender.setName(realm);
			rfAppender.setBufferSize(bufferSize);
			rfAppender.setMaxBackupIndex(cycle);
			logger.addAppender(rfAppender);
		}

		// Se richiesto scrivo sulla console
		if (prop.getBoolean(key(prefix, NLoggerManager.LOG_CONSOLE))) {
			ConsoleAppender cAppender = new ConsoleAppender((Layout) layout);
			logger.addAppender(cAppender);
		}

		NLog log = new NLog(logger);
		return log;
	}

	/**
	 * Log a message object with the <code>DEBUG</code> level.
	 * 
	 * @param commento
	 */
	public void debug(String commento) {
		NLoggerManager.livelloDebug(logger, commento);
	}

	/**
	 * Log a message object with the <code>INFO</code> level.
	 * 
	 * @param commento
	 */
	public void info(String commento) {
		NLoggerManager.livelloInfo(logger, commento);
	}

	/**
	 * Log a message object with the <code>WARN</code> level.
	 * 
	 * @param commento
	 */
	public void warn(String commento) {
		NLoggerManager.livelloWarning(logger, commento, null);
	}

	/**
	 * Log a message object with the <code>WARN</code> level including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * 
	 * @param commento
	 * @param exception
	 */
	public void warn(String commento, Throwable exception) {
		NLoggerManager.livelloWarning(logger, commento, exception);
	}

	/**
	 * Log a message object with the <code>ERROR</code> level including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * 
	 * @param commento
	 * @param exception
	 * @return
	 */
	public Ticket error(String commento, Throwable exception) {
		return NLoggerManager.livelloError(logger, commento, exception, ticketable);
	}

	/**
	 * Log a message object with the <code>ERROR</code> level.
	 * 
	 * @param commento
	 */
	public Ticket error(String commento) {
		return NLoggerManager.livelloError(logger, commento, null, ticketable);
	}

	public Ticket errorSQL(SQLException exception) {
		return NLoggerManager.livelloSQLError(logger, exception, (String) null, ticketable);
	}

	public Ticket errorSQL(SQLException exception, Sql sql) {
		return NLoggerManager.livelloSQLError(logger, exception, sql, ticketable);
	}

	public Ticket errorSQL(SQLException exception, String sql) {
		return NLoggerManager.livelloSQLError(logger, exception, sql, ticketable);
	}

	/**
	 * Log a message object with the <code>FATAL</code> level.
	 * 
	 * @param commento
	 * @return
	 */
	public Ticket fatal(String commento) {
		return NLoggerManager.livelloFatal(logger, commento, null, ticketable);
	}

	/**
	 * Log a message object with the <code>FATAL</code> level including the stack trace of the {@link Throwable} <code>t</code> passed as parameter.
	 * 
	 * @param commento
	 * @param exception
	 * @return
	 */
	public Ticket fatal(String commento, Throwable exception) {
		return NLoggerManager.livelloFatal(logger, commento, exception, ticketable);
	}

	public Logger getLogger() {
		return logger;
	}

	public boolean isTicketable() {
		return ticketable;
	}

	public void setTicketable(boolean valore) {
		ticketable = valore;
	}

	public boolean isEnable() {
		return getLevel().isGreaterOrEqual(Level.DEBUG);
	}

	public boolean isDebugLevel() {
		return getLevel().equals(Level.DEBUG);
	}

	public Level getLevel() {
		return (logger != null ? logger.getLevel() : Level.OFF);
	}

	public void remove() {
		if (logger != null)
			logger.removeAppender(logger.getName());
	}

	protected void setLogger(Logger logger) {
		this.logger = logger;
	}

}
