package it.softecspa.kahuna.log;

import org.apache.log4j.Level;

import it.softecspa.kahuna.util.calendar.EnterpriseCalendar;

public class Ticket {

	private Throwable cause;
	private Integer value;
	private EnterpriseCalendar data;

	private String commento;
	private Level level;

	@Deprecated
	public Ticket() {
		this(null, Level.ERROR);
	}

	public Ticket(Throwable cause, String commento) {
		this(cause, commento, Level.ERROR);
	}

	public Ticket(Throwable cause, String commento, Level level) {
		this.cause = cause;
		this.commento = commento;
		this.level = level;
		value = generaTicket();
		data = EnterpriseCalendar.now();
	}

	public Ticket(Throwable cause) {
		this(cause, Level.ERROR);
	}

	public Ticket(Throwable cause, Level level) {
		this.cause = cause;
		this.level = level;
		value = generaTicket();
		data = EnterpriseCalendar.now();
	}

	public static Integer generaTicket() {
		int k = 0;
		while (k == 0) {
			k = (new Double(Math.random() * 10)).intValue();
		}
		k = k * (int) 1E8;
		int d = (new Double(Math.random() * (int) 1E7)).intValue();
		return new Integer(k + d);
	}

	public String toString() {
		return value.toString();
	}

	public EnterpriseCalendar getTimestamp() {
		return data;
	}

	public Integer getValue() {
		return value;
	}

	public Throwable getCause() {
		return cause;
	}

	public void setCause(Throwable cause) {
		this.cause = cause;
	}

	public String getCommento() {
		return commento;
	}

	public void setCommento(String commento) {
		this.commento = commento;
	}

	public Level getLevel() {
		return level;
	}

}
