package it.softecspa.kahuna.mail12;


import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.lang.XString;

import java.io.FileOutputStream;
import java.io.InputStream;

import javax.activation.DataHandler;
import javax.activation.FileDataSource;

public class Allegato extends MailCommon {

	public static final String ATTACHMENT = javax.mail.Part.ATTACHMENT;
	public static final String TEXT_HTML = "text/html";
	public static final String ALTRO = "unknown";

	private String tipo = Allegato.ATTACHMENT;
	private DataHandler oggetto;
	private String fileName;
	private String filePath;
	private String altroNome;

	public Allegato(String nomefile) throws MailException {
		this(nomefile, null);
	}

	public Allegato(File file) throws MailException {
		this(file.getAbsolutePath(), null);
	}

	/**
	 * Crea un allegato da associare ad una email. Nota: The file will not
	 * actually be opened until a method is called that requires the file to be
	 * opened.
	 * 
	 * @param String
	 *            il nome del file completo da allegare.
	 */
	public Allegato(String nomefile, String altroNome) throws MailException {
		super();
		this.tipo = Allegato.ATTACHMENT;
		this.fileName = nomefile;
		this.altroNome = altroNome;

		try {
			FileDataSource fds = new FileDataSource(nomefile);
			this.oggetto = new DataHandler(fds);

		} catch (Exception e) {
			throw new MailException(e);
		}
	}

	protected Allegato(DataHandler oggetto, String filename) {
		this(Allegato.ATTACHMENT, oggetto, filename);
	}

	protected Allegato(String tipo, DataHandler oggetto, String filename) {
		super();
		this.oggetto = oggetto;
		this.tipo = tipo;
		/* ------- */
		this.fileName = filename;
		if (this.fileName == null)
			this.fileName = "";
	}

	
	
	protected void setTipo(String tipo) {
		// controlla la coerenza del tipo
		this.tipo = tipo;
	}

	/**
	 * Restituisce il tipo dell'allegato.
	 * 
	 * @return una stringa corrispondente al tipo di allegato.
	 */
	public String getTipo() {
		return this.tipo;
	}

	protected void setFileName(String valore) {
		this.fileName = valore;
	}

	/**
	 * Restituisce il nome del file incluso nell'allegato. Se l'allegato non 
	 * un file il metodo pu ritornare <B>null</B>.
	 * 
	 * @return una stringa contenente il nome.
	 */
	public String getFileName() {
		return this.fileName;
	}

	/**
	 * Scarica l'allegato sul disco nel percorso indicato
	 * 
	 * @param String
	 *            la cartella dove salvare il file
	 */
	public boolean salvaSuDisco(String percorso) throws MailException {
		if (!tipo.equals(Allegato.ATTACHMENT))
			return false;

		if (XString.isBlankNull(fileName)) {
			throw new MailException("Nome file non indicato o non valido");
		}
		if (XString.isNotBlankNull(percorso))
			filePath = percorso;
		filePath = XString.isNotBlankNull(filePath) ? File.rationalizePath(filePath) : "";
		String scaricaFile = filePath + this.fileName;
		int byteRead = 0;
		boolean eof = false;
		try {
			FileOutputStream fileOut = new FileOutputStream(scaricaFile);
			InputStream inStream = this.oggetto.getInputStream();
			while (!eof) {
				int c = inStream.read();
				if (c == -1) {
					eof = true;
				} else {
					fileOut.write(c);
					if (log.isTraceEnabled()) byteRead++;
				}
			}
			fileOut.close();
			if (log.isTraceEnabled()) log.trace("Scritti su disco " + byteRead + " bytes");

		} catch (Exception e) {
			throw new MailException(e);
		}

		return true;
	}

	protected DataHandler getDataHandler() {
		return this.oggetto;
	}

	protected String getNome() {
		return altroNome != null ? altroNome : this.oggetto.getName();
	}
}