package it.softecspa.kahuna.mail12;


/**
 * Title: Description: Copyright: Copyright (c) 2002, 2006 Company:
 * 
 * @author il Vera
 * @version 1.1
 */

public class Cassetta extends MailCommon {

	public Invio invio = null;
	public Ricezione ricezione = null;

	/**
	 * Definisce una casella di posta elettronica.
	 */
	public Cassetta(String nome) throws MailException {
		this(nome, Protocollo.IMAP, Protocollo.SMTP);
	}

	/**
	 * Definisce una casella di posta elettronica impostando i protocolli di
	 * comunicazione con il server di posta e le dimensioni delle liste.
	 * 
	 * @param String
	 *            protocollo di ricezione posta (<B>IMAP</B>, <B>POP3</B>).
	 * @param String
	 *            protocollo di invio posta (<B>SMTP</B>).
	 */
	public Cassetta(String nome, Protocollo protRicezione, Protocollo protInvio) throws MailException {
		super();
		if (!protRicezione.equals(Protocollo.IMAP) & !protRicezione.equals(Protocollo.POP3))
			throw new MailException("Protocollo di posta in ARRIVO non valido: " + protRicezione);

		if (!protInvio.equals(Protocollo.SMTP))
			throw new MailException("Protocollo di posta in USCITA non valido: " + protInvio);

		// Creazione e dimensionamento delle liste
		invio = new Invio(nome);
		ricezione = new Ricezione(nome);

		// Impostazione dei protocolli
		invio.setProtocollo(protInvio);
		ricezione.setProtocollo(protRicezione);

	}

	
	public String getNome() {
		return ricezione.getNome();
	}

}