package it.softecspa.kahuna.mail12;

import it.softecspa.kahuna.lang.XString;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.SendFailedException;
import javax.mail.Session;
import javax.mail.Transport;

public class Invio extends Servente {

	public static final boolean TUTTA_LA_POSTA = true;
	public static final boolean POSTA_DA_SPEDIRE = false;
	private boolean bAutenticazione = false;

	private List<Lettera> lettere_non_spedite;

	public Invio() {
		this("Invio");
	}

	public Invio(String nome) {
		super(nome);
		lettere_non_spedite = new ArrayList<Lettera>();
	}

	/**
	 * Imposta i parametri per la connessione al server di posta con
	 * autenticazione
	 * 
	 * @param host
	 *             il nome del server
	 * @param user
	 *             l'utenza per la connessione
	 * @param password
	 *             la password
	 */
	public void setConfigurazione(String host, String user, String password, String localhost) {
		super.setHost(host);
		super.setLocalhost(localhost);

		if (XString.isBlankNullTrim(user))
			user = null;
		if (XString.isBlankNullTrim(password))
			password = null;
		if (user == null || password == null) {
			this.bAutenticazione = false;
			return;
		}

		super.setUser(user);
		super.setPassword(password);
		this.bAutenticazione = true;
	}

	public void setConfigurazione(String host, String user, String password) {
		setConfigurazione(host, user, password, null);
	}

	/**
	 * Imposta i parametri per la connessione al server di posta
	 * 
	 * @param host
	 *             il nome del server
	 */
	public void setConfigurazione(String host) {
		super.setHost(host);
		this.bAutenticazione = false;
	}

	/**
	 * Imposta i parametri per la connessione al server di posta
	 * 
	 * @param host
	 *             il nome del server
	 */
	public void setConfigurazione(String host, String localhost) {
		super.setHost(host);
		super.setLocalhost(localhost);
		this.bAutenticazione = false;
	}

	/**
	 * Infila una lettere nella buca delle lettere.
	 * 
	 * @param Lettera
	 *            da inviare.
	 * @return il numero di email nella lista.
	 */
	public int addLettera(Lettera lettera) throws MailException {
		return super.addLettera(lettera);
	}

	/**
	 * Svuota la lista della posta in Uscita gi spedita.
	 * 
	 * @return <B>true</B> se l'operazione  riuscita.
	 */
	public boolean removeAllLettereSpedite() {
		try {
			for (int i = super.getLettere().size() - 1; i >= 0; i--) {
				Lettera lettera = (Lettera) super.getLettere().get(i);
				if (lettera.isSpedita()) {
					super.getLettere().remove(i);
				}
			}
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	public boolean removeAllLettera() {
		if (super.removeAllLettera()) {
			return removeAllLetteraNonSpedite();
		}
		return false;
	}

	public boolean removeAllLetteraNonSpedite() {
		try {
			lettere_non_spedite.clear();
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Invia le email presenti nella lista ma <I>non ancora inviate</I>. Non
	 * viene generata alcuna eccezione. Eventuali errori di ricezione devono
	 * essere verificati con i metodi <I>errorState()</I> e
	 * <I>printErrorStack()</I>
	 * 
	 * @return <B>true</B> se tutte le mail sono state inviate correttamente.
	 */

	public boolean esegui() throws MailException {
		return esegui(false);
	}

	/**
	 * Invia le email presenti nella lista. Non viene generata alcuna eccezione.
	 * Eventuali errori di ricezione devono essere verificati con i metodi
	 * <I>errorState()</I> e <I>printErrorStack()</I>
	 * 
	 * @param boolean se settato a <B>true</B> invia soltanto le mail che non
	 *        sono ancora state inviate.
	 */

	public boolean esegui(boolean inviaTutto) throws MailException {
		int n = 0;
		boolean bOk = true;

		log.debug("Casella '" + super.getNome() + "', " + this.getProtocollo() + ", in spedizione...");

		// Controllo della esistenza dei paramtri fondamentali
		if (this.getHost() == null && this.getUrl() == null) {
			throw new MailException("Manca un parametro fondamentale: HOST o URL");
		}
		if (this.getProtocollo() == null) {
			throw new MailException("Manca un parametro fondamentale: PROTOCOLLO");
		}
		if (this.bAutenticazione) {
			if (this.getUser() == null ^ this.getPassword() == null) {
				throw new MailException("Se indicati i parametri USER e PASSWORD devono andare in coppia");
			}
		}

		if (super.lista.isEmpty()) {
			if (log.isTraceEnabled()) log.trace("Nessun messaggio da inviare");
		} else {
			n = 0;
			if (this.getUser() != null && this.getPassword() != null) {
				bAutenticazione = true;
			}

			// Effettuo la connessione con il server di posta
			Properties props = System.getProperties();
			props.put("mail.smtp.host", this.getHost());
			if (XString.isNotBlankNull(this.getLocalhost()))
				props.put("mail.smtp.localhost", this.getLocalhost());
			if (this.getUser() != null) {
				props.put("mail.user", this.getUser());
				props.put("mail.password", this.getPassword());
			}

			props.put("mail.smtp.auth", bAutenticazione ? "true" : "false");
			Authenticator auth = null;

			// URLName urlName = new URLName(this.getHost());
			Session session = Session.getDefaultInstance(props, bAutenticazione ? auth : null);
			setSessionDebugLevel(session);
			try {
				Transport transport = session.getTransport("smtp");
				if (bAutenticazione) {
					transport.connect(this.getHost(), this.getUser(), this.getPassword());
				} else {
					transport.connect();
				}
				// Ciclo su tutte le lettere della cassetta
				for (Iterator<Lettera> elemento = super.lista.iterator(); elemento.hasNext();) {
					Lettera lettera = elemento.next();
					n++;
					try {
						// ...controllo spedizione
						if (inviaTutto || (!lettera.isSpedita())) {
							log.debug("Invio mail n. " + n + " - '" + lettera.getOggetto()+"'");

							Message msg = lettera.getMessage(session);
							msg.saveChanges(); // don't forget this
							transport.sendMessage(msg, msg.getAllRecipients());
							// transport.sendMessage(msg,
							// msg.getAllRecipients()); // non funzionano gli
							// allegati

							lettera.setSpedita(true);
						} else {
							log.debug("Invio mail n. " + n + " - [saltato] - '" + lettera.getOggetto()+"'");
						}
					} catch (SendFailedException e) {
						// vado avanti e provo a spedire le altre email:
						log.warn("Mail non inviata: " + e.getMessage(), e);
						lettera.setErrata(e.getMessage());
						lettere_non_spedite.add(lettera);
						bOk = false;

					} catch (MailException e) {
						// vado avanti e provo a spedire le altre email:
						log.warn("Mail non inviata: " + e.getMessage(), e);
						lettera.setErrata(e.getMessage());
						lettere_non_spedite.add(lettera);
						bOk = false;
					}
				}
				transport.close();
			} catch (Exception e) {
				throw new MailException("Errore durante il dialogo con il server",e);
			}
		}
		return bOk;
	}



	public List<Lettera> getLettereNonSpedite() {
		return lettere_non_spedite;
	}

}
