package it.softecspa.kahuna.mail12;

/**
 * Title:
 * Description:
 * Copyright:    Copyright (c) 2002, 2006
 * Company:
 * @author il Vera
 * @version 1.1
 */

import it.softecspa.kahuna.log.LoggingOutputStream;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;

import javax.mail.Session;

import org.apache.log4j.Level;

public class Servente extends MailCommon {

	//boolean advanced_debug = log.getLogger().isTraceEnabled();
	//boolean advanced_video = log.getLogger().isTraceEnabled();

	private Protocollo protocollo;
	private String host;
	private String user;
	private String password;
	private String localhost;

	private String url;
	private int porta = -1;
	@SuppressWarnings("unused")
	private int stato = -1;

	// protected List<Lettera> lista = null; // compliant java 5
	protected List<Lettera> lista;

	protected String nome;

	protected Servente() {
		this("Profonda");
	}

	protected Servente(String nome) {
		super();
		this.nome = nome;
		lista = new ArrayList<Lettera>();
		porta = -1;
		stato = -1;
	}

	protected String getNome() {
		return nome;
	}

	private String getX(String valore) {
		return (valore != null && valore.trim().equals("") ? null : valore);
	}

	/**
	 * Restituisce il protocollo con cui  effettato il colloquio con il server
	 * specificato.
	 */
	public Protocollo getProtocollo() {
		return protocollo;
	}

	protected void setProtocollo(Protocollo valore) {
		this.protocollo = valore;
	}

	/**
	 * Restituisce il nome del server di posta utilizzato.
	 * 
	 * @return il nome del server.
	 */
	public String getHost() {
		return getX(host);
	}

	/**
	 * Imposta il nome del server di posta utilizzato.
	 * 
	 * @param String
	 *            corrisponde al nome del server.
	 */
	public void setHost(String valore) {
		this.host = valore;
	}

	/**
	 * Restituisce il nome utente con cui viene fatta la connessione al server
	 * di posta.
	 * 
	 * @return il nome utente.
	 */
	public String getUser() {
		return getX(user);
	}

	/**
	 * Imposta l'utente per la connessione con il server, se necessaria.
	 * 
	 * @param String
	 *            nome utente.
	 */
	public void setUser(String valore) {
		this.user = valore;
	}

	/**
	 * Restituisce la password con cui viene fatta la connessione al server di
	 * posta.
	 * 
	 * @return la password.
	 */
	public String getPassword() {
		return getX(password);
	}

	/**
	 * Imposta la password per la connessione con il server, se necessaria.
	 * 
	 * @param String
	 *            password.
	 */
	public void setPassword(String valore) {
		this.password = valore;
	}

	public String getUrl() {
		return getX(url);
	}

	public void setUrl(String valore) {
		this.url = valore;
	}

	/**
	 * Restituisce la porta a cui  conesso il server di posta. (-1 indica la
	 * porta di default)
	 * 
	 * @return la porta.
	 */
	public int getPorta() {
		return porta;
	}

	/**
	 * Imposta la porta per la connessione al server di posta. (-1 indica la
	 * porta di default)
	 * 
	 * @parma int la porta.
	 */
	public void setPorta(int valore) {
		this.porta = valore;
	}

	public List<Lettera> getLettere() {
		return lista;
	}

	/**
	 * Infila una lettere nella cassetta delle lettere da spedire.
	 * 
	 * @param Lettera
	 *            da inviare.
	 * @return il numero di email nella lista.
	 */
	protected int addLettera(Lettera lettera) throws MailException {
		try {
			lista.add(lettera);

			return lista.size();
		} catch (Exception e) {
			throw new MailException(e);
		}
	}

	/**
	 * Toglie la lettera indicata dalla buca delle lettere.
	 * 
	 * @param int il numero della lettera da togliere.
	 * @return il numero di email nella lista.
	 */
	public int removeLettera(int numero) throws MailException {
		if ((numero < 0) || (numero >= lista.size()))
			return 0;

		try {
			lista.remove(numero);
			return lista.size();
		} catch (Exception e) {
			throw new MailException(e);
		}
	}

	/**
	 * Svuota la lista della posta in Uscita.
	 * 
	 * @return <B>true</B> se l'operazione  riuscita.
	 */
	public boolean removeAllLettera() {
		try {
			lista.clear();
		} catch (Exception e) {
			return false;
		}
		return true;
	}

	/**
	 * Restituisce in numero di lettere in memoria.
	 * 
	 * @return il numero di lettere.
	 */
	public int size() {
		return (lista == null ? 0 : lista.size());
	}

	/**
	 * Restituisce la lettera nella posizione indicata nella lista. Viene
	 * generata una eccezione se la lettera non esiste.
	 * 
	 * @param int il numero della lettera che si desidera.
	 * @return la lettera.
	 */
	public Lettera getLettera(int numero) throws MailException {
		if ((numero < 0) || (numero >= lista.size()))
			throw new MailException("La mail n. " + numero + " non esite nella coda della posta in uscita");
		return (Lettera) lista.get(numero);
	}

	public String getLocalhost() {
		return localhost;
	}

	public void setLocalhost(String localhost) {
		this.localhost = localhost;
	}

	
	
	void setSessionDebugLevel(Session session) {
		if (log.isTraceEnabled()) {
			session.setDebug(true);
			// Redireziona il log da System.out a loggger LOG4J
			session.setDebugOut(new PrintStream(new LoggingOutputStream(log.getLogger(), Level.TRACE), true));
		}
		
	}
	
}