package it.softecspa.kahuna.services;


import it.softecspa.kahuna.mail12.Cassetta;
import it.softecspa.kahuna.mail12.Lettera;
import it.softecspa.kahuna.mail12.MailException;
import it.softecspa.kahuna.mail12.Protocollo;
import it.softecspa.kahuna.util.Properties;



public class PostOffice {
	
	
	// Configurazione mail
	private static final String PREFIX_MAIL = "mail.";
	public static final String MAIL_ENABLE 		= PREFIX_MAIL + "enable";
	// Configurazione SMTP per invio mail
	public static final String MAIL_SMTP_HOST 		= PREFIX_MAIL + "smtp.host";
	public static final String MAIL_SMTP_LOCALHOST 	= PREFIX_MAIL + "smtp.localhost";
	public static final String MAIL_SMTP_USER 		= PREFIX_MAIL + "smtp.user";
	public static final String MAIL_SMTP_PASSWORD 	= PREFIX_MAIL + "smtp.password";
	
	
	
	public static final String MAIL_FROM 		= PREFIX_MAIL + "from";
	public static final String MAIL_TO 			= PREFIX_MAIL + "to";
	public static final String MAIL_CC 			= PREFIX_MAIL + "cc";
	public static final String MAIL_BCC 		= PREFIX_MAIL + "bcc";

	public static final String MAIL_SUBJECT 	= PREFIX_MAIL + "subject";
	public static final String MAIL_TEXT 		= PREFIX_MAIL + "text";

	
	
	

	
	
	private static PostOffice instance;

	private Cassetta cassetta;
	
	private String smtp;
	private String localhost;
	private String user;
	private String password;

	private PostOffice() throws MailException {
		super();
		synchronized (PostOffice.class) {
			if (instance == null) {
				instance = this;
			}
		}
	}

	public static PostOffice getInstance() throws MailException {
		synchronized (PostOffice.class) {
			if (instance == null) new PostOffice();
		}
		return instance;
	}

	
	
	public void setup(Properties prop) {
		setup(prop,"");
	}
	
	/**
	 * Configurazione postoffice
	 * @param prop
	 * @param prefix
	 */
	public void setup(Properties prop, String prefix) {
		// ...parametri da impostare una-tantum
		setSmtp(prop.get(prefix+MAIL_SMTP_HOST));
		setLocalhost(prop.get(prefix+MAIL_SMTP_LOCALHOST));
		setUser(prop.get(prefix+MAIL_SMTP_USER));
		setPassword(prop.get(prefix+MAIL_SMTP_PASSWORD));		
	}
	
	
	
	public void spedisci(Lettera lettera) throws MailException {
		spedisci(new Lettera[] { lettera });
	}
	
	public void spedisci(Lettera[] lettera) throws MailException {
		
		
		checkCassetta();
		synchronized (cassetta) {
			if (lettera != null && lettera.length > 0) {
				for (int i = 0; i < lettera.length; i++) {
					if (lettera[i] != null)
						cassetta.invio.addLettera(lettera[i]);
				}

				cassetta.invio.esegui();

				// TODO perfezionare
				// Ripulisco la casella postale cancellando tutte le lettere
				// dalla casella
				cassetta.invio.removeAllLettera();
				// TODO dovrei mettere su un sistema che permatta in automatico
				// di reinviare le lettere non spedite
			}
		}
	}

	/*
	 * private void inbuca(Lettera lettera) throws MailException { synchronized
	 * (cassetta) { cassetta.invio.addLettera(lettera); } }
	 * 
	 * private void spedisci() throws MailException { synchronized (cassetta) {
	 * cassetta.invio.esegui(); } }
	 */

	public void flushErrate() throws MailException {
		checkCassetta();
		synchronized (cassetta) {
			cassetta.invio.removeAllLetteraNonSpedite();
		}
	}

	public void flushAll() throws MailException {
		checkCassetta();
		synchronized (cassetta) {
			cassetta.invio.removeAllLettera();
		}
	}

	public String getSmtp() {
		return smtp;
	}

	public void setSmtp(String smtp) {
		this.smtp = smtp;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void checkCassetta() throws MailException {
		if (cassetta == null)
			inizialize();
	}

	private void inizialize() throws MailException {
		// Configurazione cassetta postale
		cassetta = new Cassetta("Mandrake", Protocollo.POP3, Protocollo.SMTP);
		cassetta.invio.setConfigurazione(smtp, user, password, localhost);
	}

	public String getLocalhost() {
		return localhost;
	}

	public void setLocalhost(String localhost) {
		this.localhost = localhost;
	}

	

	
  
  
  
}
