package it.softecspa.kahuna.services;

import java.util.ArrayList;
import java.util.List;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.mail12.Lettera;
import it.softecspa.kahuna.services.PostOffice;
import it.softecspa.portal.ApplicationClusterInfo;
import it.softecspa.portal.Parameters;
import it.softecspa.portal.Version;

import org.apache.log4j.Logger;

public class PostmanPat {

	private Logger log = Logger.getLogger(getClass());
	
	// Caso particolare in cui non voglio inviare la versione del portale
	private boolean noVersion = false;
	private boolean noNormalize = false;
		
	private Lettera lettera;
	
	private String subject;
	private String message;
	//
	private final String BR = "<br>";
	private final String LINE_FEED = "\n";
	
	private String lf;
	
	private List<String> to; 
	private List<String> cc;
	private List<String> bcc;
	
	
	public PostmanPat() {
		this(Lettera.CONTENT_TYPE_HTML);
	}
	
	public PostmanPat(String content_type) {
		this.lettera = new Lettera();
		lettera.setXPriority(Lettera.XPRIORITY_HIGH);
		lettera.setContetType(content_type);
		this.message="";
		
		if (Lettera.CONTENT_TYPE_HTML.equalsIgnoreCase(content_type)) {
			this.lf = BR;
		} else {
			this.lf = LINE_FEED;
		}
		
	}
	
	
	public void setSubject(String subject) {
		this.subject = subject;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public void addMessage(String message) {
		this.message += message + lf;
	}
	
	public void setXpriority(String xpriority) {
		lettera.setXPriority(xpriority);
	}
		
	public String getMessage() {
		return "<p>"+message+"</p>";
	}
	

	/**
	 * Invia una mail agestore del servizio con la segnalazione
	 */
	public boolean send() {
		
		Parameters parameters = Parameters.getInstance();
		if (!parameters.getBoolean(PostOffice.MAIL_ENABLE, false)) return false;
		
		log.info("Sending a mail using "+getClass().getSimpleName());
		try {
			// Invia la mail
			PostOffice postOffice = PostOffice.getInstance();
			// .....
			if (postOffice == null) {
				log.warn("PostOffice not configured");
				return false;
			}	
			
			
			String hostname = ApplicationClusterInfo.getInstance().getHostNameAddress();
			
			String _from = parameters.get(PostOffice.MAIL_FROM);
			if (_from.indexOf("<") < 0) {
				_from = (hostname != null ? "Host " + hostname : "Unknown host") + "<" + _from + ">";
			}
			
			lettera.setMittente(_from);
			lettera.addDestinatario(parameters.get(PostOffice.MAIL_TO));
			if (to!=null) {
				for (String address : to) {
					lettera.addDestinatario(address);
				}
			}
			lettera.addCC(parameters.get(PostOffice.MAIL_CC));
			if (cc!=null) {
				for (String address : cc) {
					lettera.addCC(address);
				}
			}
			lettera.addBCC(parameters.get(PostOffice.MAIL_BCC));
			if (bcc!=null) {
				for (String address : bcc) {
					lettera.addBCC(address);
				}
			}

			lettera.setOggetto(parameters.get(PostOffice.MAIL_SUBJECT) + " " + subject);
			
			
			Version versione = Version.getInstance();
			String installation = parameters.get(Parameters.APPLICATION_ENVIRONMENT);
			String appname = parameters.get(Parameters.APPLICATION_NAME,"Server application unknown");

			String testo = "";
			if (!noVersion) {
				testo += "<b>"+appname+"</b>, version: " + versione.getVersion() + " <i>(build "+versione.getBuild()+")</i> " + installation + lf +
						 (hostname != null ? "Host <b>" + hostname + "</b>" : "Unknown host") + lf +
						 lf;
			}
						   
			// ...aggiungo il messaggio
			if (XString.isNotBlankNullTrim(message)) {
				testo += message + lf;
			}
			
			if (!noNormalize) {
				// Normalizzazione messagio
				// http://www.regular-expressions.info/characters.html
				// -------------------------------------------------
				if (this.lf.equalsIgnoreCase(BR)) {
					testo = testo.replaceAll("\\x0A", BR); 			// LF \n
					testo = testo.replaceAll("\\x0D", ""); 			// CR \r
					testo = testo.replaceAll("\\x09", "&nbsp;"); 	// TAB \t
				}
				// -------------------------------------------------
			}
			//
			
			lettera.setTesto(testo);
			postOffice.spedisci(lettera);
			return true;
			
		} catch (Exception e) {
			log.warn("Error sending mail", e);
		}
		return false;
	}

	public String getLF() {
		return lf;
	}

	
	public boolean isNoVersion() {
		return noVersion;
	}

	public void setNoVersion(boolean noVersion) {
		this.noVersion = noVersion;
	}
	
	
	public boolean isNoNormalize() {
		return noNormalize;
	}

	public void setNoNormalize(boolean noNormalize) {
		this.noNormalize = noNormalize;
	}
	

	public List<String> getTo() {
		return to;
	}

	public void setTo(List<String> to) {
		this.to = to;
	}

	public void addTo(String address) {
		if (to==null) to = new ArrayList<String>();
		this.to.add(address);
	}

	
	public List<String> getCc() {
		return cc;
	}

	public void setCc(List<String> cc) {
		this.cc = cc;
	}
	
	
	public void addCc(String address) {
		if (cc==null) cc = new ArrayList<String>();
		this.cc.add(address);
	}

	public void addBcc(String address) {
		if (bcc==null) bcc = new ArrayList<String>();
		this.bcc.add(address);
	}

	public List<String> getBcc() {
		return bcc;
	}

	
	
	

	public void setBcc(List<String> bcc) {
		this.bcc = bcc;
	}



	
}