package it.softecspa.kahuna.services.console;

import it.softecspa.kahuna.springframework.KSpringEngine;

import java.util.Hashtable;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import org.springframework.jmx.export.naming.MetadataNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;

public class KahunaNamingStrategy extends MetadataNamingStrategy {

	static String TYPE = "type";
	static String UNIT = "unit";
	static String NAME = "name";
	
	private String domainName;
	
	
	@Override
	public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
		
		ObjectName on = super.getObjectName(managedBean, beanKey);		
		
				
		// Personalizzazione nome dominio
		String instanceId = KSpringEngine.getUniqueId();
		
		
		if (instanceId!=null || domainName!=null) {
			String domain = on.getDomain();
			if (domainName!=null) domain = domainName;
			
			String newDomain = domain+" ("+instanceId+")";
			
			Hashtable<String, String> ht = on.getKeyPropertyList();
			String type = ht.get(TYPE);
			String unit = ht.get(UNIT);
			String name = ht.get(NAME);
			
			String canonicalName = newDomain+":"+(type!=null?TYPE+"="+type+",":"")+
												 (unit!=null?UNIT+"="+unit+",":"")+
												             NAME+"="+name;
			return ObjectNameManager.getInstance(canonicalName);
			
		} else {
			return on;
		}
		
	}


	public String getDomainName() {
		return domainName;
	}

	public void setDomainName(String domainName) {
		this.domainName = domainName;
	}

	
	/*
	 public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
		
		ObjectName on = super.getObjectName(managedBean, beanKey);		
		Hashtable ht = on.getKeyPropertyList();
		
		
		String domain = on.getDomain();
		String name = (String) ht.get("name");
		if (name == null)
			name="";
		String type = (String) ht.get("type");
		
		
		String instanceId = KSpringEngine.getUniqueId();; 
		
		String newDomain="";
		String newName="";
		
		if (instanceId!=null)
			newDomain=domain+" ("+instanceId+")";
		else
			newDomain=domain;
		
		if (managedBean instanceof NamedResource){
			String subName=((NamedResource)managedBean).getAdministredResourceName();
			if (subName == null)
				subName=beanKey;
			
			newName=name+"-"+subName;
		} else
			newName=name;
						
		String canonicalName=newDomain+":"+(type!=null?"type="+type+",":"")+"name="+newName;
			
		ObjectName non = ObjectNameManager.getInstance(canonicalName);

		return non;
	}	  
	 */
}
