package it.softecspa.kahuna.springframework;

import java.util.Hashtable;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

import org.springframework.context.support.AbstractApplicationContext;

public abstract class SpringContext implements Context {

	public Object addToEnvironment(String propName, Object propVal)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void bind(Name name, Object obj) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void bind(String name, Object obj) throws NamingException {
		throw new NamingException("Non Implemented Operation");	}

	public void close() throws NamingException {
	}

	public Name composeName(Name name, Name prefix) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public String composeName(String name, String prefix)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Context createSubcontext(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Context createSubcontext(String name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void destroySubcontext(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void destroySubcontext(String name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Hashtable<?, ?> getEnvironment() throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public String getNameInNamespace() throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public NameParser getNameParser(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public NameParser getNameParser(String name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public NamingEnumeration<NameClassPair> list(Name name)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public NamingEnumeration<NameClassPair> list(String name)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}
	
	public NamingEnumeration<Binding> listBindings(Name name)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public NamingEnumeration<Binding> listBindings(String name)
			throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}
	
	public Object lookupLink(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Object lookupLink(String name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void rebind(Name name, Object obj) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void rebind(String name, Object obj) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Object removeFromEnvironment(String propName) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void rename(Name oldName, Name newName) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void rename(String oldName, String newName) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void unbind(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public void unbind(String name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	
	public Object lookup(Name name) throws NamingException {
		throw new NamingException("Non Implemented Operation");
	}

	public Object lookup(String name) throws NamingException {
		AbstractApplicationContext springContext = getAppContext();
		if (springContext == null)
			throw new NamingException("Spring Context NULL");
		
		return springContext.getBean(name);
	}

	public abstract AbstractApplicationContext getAppContext();
	
	@SuppressWarnings("unchecked")
	public String getSpringName(Object obj){
		
		if (obj == null)
			return "";
				
		Class className=obj.getClass();
		//System.out.println("Searcing "+className.getName()+" for "+obj);
		
		AbstractApplicationContext ctx = getAppContext();
		if (ctx == null)
			return "";
		
		String[] beanNames=ctx.getBeanNamesForType(className);
		
		if ( beanNames == null || beanNames.length == 0)
			return "";
		
		
		for (int i=0;i<beanNames.length;i++){
			//System.out.println("Check "+beanNames[i]);
			
			if (ctx.getBean(beanNames[i])==obj)
				return beanNames[i];
		}
		
		return "";
	}
}
