package it.softecspa.kahuna.springframework;

import it.softecspa.kahuna.io.File;
import it.softecspa.kahuna.util.Properties;

import java.io.FileNotFoundException;
import java.io.IOException;

import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;


@SuppressWarnings("serial")
public class SpringProperties extends Properties {

	public SpringProperties() {
		super();
	}

	
	public void setLocation(String location) throws FileNotFoundException, IOException {
		String resolvedLocation = SystemPropertyUtils.resolvePlaceholders(location);
		File file = new File(ResourceUtils.getFile(resolvedLocation));
		load(file);
	}	
}
