package it.softecspa.kahuna.sql;

import it.softecspa.kahuna.log.NLoggerManager;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.SQLException;



public class IBlob {

  File valore;
  
  public IBlob(File valore) {
    this.valore = valore;
  }

  public int length() {    
    return new Long(valore.length()).intValue();
  }
  
  
  public FileInputStream getReader() throws FileNotFoundException  {
    return new FileInputStream(valore);
  }
  
  
  public String toString() {
    return valore.toString();
  }


  public static byte[] getBytes(ResultSet res, String campo) throws SQLException {
    try {
      // Get as a BLOB
      Blob aBlob = res.getBlob(campo);
      return aBlob.getBytes(1, (int)aBlob.length());
   
    } catch(Exception e) {
      
      // The driver could not handle this as a BLOB...
      // Fallback to default (and slower) byte[] handling
      NLoggerManager.livelloWarning(e.toString());      
      return res.getBytes(campo);
    }
  }

  public File getValore() {
    return valore;
  }
  
  
  
  
}
