package it.softecspa.kahuna.sql;

import it.softecspa.kahuna.lang.XString;
import it.softecspa.kahuna.log.NLoggerManager;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;



public class IClob {

  String valore;
  
  public IClob(String valore) {
    this.valore = valore;
  }

  public IClob(XString valore) {
    this.valore = valore.toString();
  }

  
  public int length() {    
    return valore.length();
  }

  
  public Reader getReader() {
    return new StringReader(valore);
  }
  
  
  public String toString() {
    return valore;
  }

  public static String getString(ResultSet res, String campo) throws SQLException {
    try {
      // Get as a BLOB
      Clob aClob = res.getClob(campo);

      long  len = aClob.length();
      byte[] buf = new byte[(int)len];
      InputStream in = aClob.getAsciiStream();
      in.read(buf);
      in.close();
            
      return new String(buf);
   
    } catch(Exception e) {
      
      // The driver could not handle this as a CLOB...
      NLoggerManager.livelloWarning(e.toString());      
      return res.getString(campo);
    }
  }
  
}
