package it.softecspa.kahuna.sql;

import it.softecspa.kahuna.lang.XString;

import org.apache.log4j.Logger;

public class QueryFormatter {

	private Logger log = Logger.getLogger(getClass());
	
	private String origine;	
	private String appoggio;
	private String formattata;
	
	
	public QueryFormatter() {
		
	}
	
	public String toString(String query) {
		if (XString.isBlankNullTrim(query)) return null;
		try {
			origine = query.replaceAll("\r\n","\n");
			origine = query.replaceAll("\r","");
			origine = origine.replaceAll("\n","\r"); // barbatrucco
			origine = origine.trim();
			
			appoggio = origine.toUpperCase();
			formattata = "";
			
			int pos = -1;			
			pos = parsestart(pos,"INSERT");
			pos = parse(pos,"DELETE", '\r','\r',true);
			pos = parsestart(pos,"UPDATE");
						
			pos = parse(pos,"SET");
			pos = parse(pos,"VALUES",' ','(');
			pos = parse(pos,"VALUES",' ',' '); // Caso alternativo
			
			pos = parse(pos,"UNION");
			pos = parse(pos,"SELECT");
			pos = parse(pos,"FROM");
			pos = parse(pos,"OUTER JOIN");
			pos = parse(pos,"LEFT JOIN");
			pos = parsecicle(pos,"JOIN");
			pos = parse(pos,"WHERE");
			pos = parsecicle(pos,"AND");
			pos = parse(pos,"GROUP BY");
			pos = parse(pos,"HAVING");
			pos = parse(pos,"ORDER BY");
			pos = parse(pos,"LIMIT");		
			if (pos>=0) {
				formattata += origine.substring(pos);
			}
			// ...non ho parserizzato niente, quindi
			if (formattata.length()==0) formattata=origine;
			
			formattata = formattata.replaceAll("\r","\n");   // barbatrucco
			formattata = formattata.replaceAll("\n\n","\n"); // barbatrucco
			return formattata; 
		
		} catch (Exception e) {
			if (log.isDebugEnabled()) {
				log.debug("ERROR formatting query, view stacktrace",e);
			}			
			return query;
		}
	}
	
	private int parse(int precedente, String search) {
		return parse(precedente, search, ' ', ' ', false);
	}
	
	private int parsestart(int precedente, String search) {
		return parse(precedente, search, ' ', ' ', true);
	}
	
	private int parse(int precedente, String search, char after, char before) {
		return parse(precedente, search, after, before, false);
	}
	
	private int parse(int precedente, String search, char after, char before, boolean startWith) {
		int i = appoggio.indexOf(search, precedente);
		if (i>=0) {
			// Faccio una ulteriore verifica che questa sia una parola chiave
			int l = search.length();
			
			if (startWith) {
				// Questa parola chiave deve trovarsi in posizione 0
				if (i>0) {
					return precedente;
				}
			}	
			
			/* 
			 * Verifico che il carattere prima o dopo la parola chiave sia uno spazio
			 * Se non  cos allora questa non  la parola chiave che cerco
			 */		
			if (i>0 && origine.charAt(i-1)!=after) return precedente;
			try { if (origine.charAt(i+l)!=before) return precedente;	} catch (Exception e) { /* Ritorna una eccezione se  finita la stringa, e quindi non faccio niente */	}
						
			if (precedente>=0) {
				formattata += origine.substring(precedente, i)+"\n";
			}
			// che  maiuscola
			formattata += search;
			return i+l;
		
		}
		return precedente;
	}
	
	private int parsecicle(int precedente, String search) {
		int base = precedente+1;
		do {
			int i = appoggio.indexOf(search, base);
			if (i<0) return precedente;
		
			formattata += origine.substring(precedente, i)+"\n";
			precedente = i;
			base = i+1;
	
		} while (true);
	}
	
	
	/**
	 * @deprecated
	 * @param logger
	 * @param query
	 */
	public static void toLogger(Logger logger, String query) {
		logTrace(logger, query);
	}
	
	
	public static void logError(Logger logger, String query, Throwable e) {
		toLogger(logger, query, e);
	}
		
	public static void logTrace(Logger logger, String query) {
		toLogger(logger, query, null);
	}
	
	private static void toLogger(Logger logger, String query, Throwable e) {
		if (logger==null) return;
		//
		QueryFormatter qf = new QueryFormatter();
		query = qf.toString(query);
		//
		Sql.stampaSQL(logger, (query!=null?query:"NONE"), e);		
	}
	
}
