package it.softecspa.kahuna.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.log4j.Logger;

/*
 * TODO da completare implementazione
 */

@SuppressWarnings("unused")
public class SqlStatement {

	private static Logger log = Logger.getLogger("it.softecspa.kahuna.SQL");

	// Connessione al database
	private Connection connection;

	// Statement creato per le query sql
	private PreparedStatement res_stmt;
	private ResultSet res;

	// Numero di record aggiornati nell'ultima operazione di executeUpdate()
	private int updateCount;

	// Elenco delle variabili da passare come Preparedstatement
	private List<String> columns;
	private List<String> values;
	private List<String> binds;
	private List<String> tables;

		
	private SqlStatement() {
		super();
	}

	/**
	 * Crea l'oggetto e lo associa ad una istanza <I>Connection</I>.
	 */
	public SqlStatement(Connection conn) throws SQLException {
		this();
		connection = conn;
	}

	/**
	 * Crea l'oggetto a partire da una istanza SqlPlus.
	 */
	public SqlStatement(Sql sql) {
		this();
		connection = sql.getConnection();
	}

	/**
	 * Crea l'oggetto a partire da un'altra istanza SqlPlus.
	 */
	public SqlStatement(SqlStatement sql) {
		this();
		connection = sql.getConnection();
	}

	protected void finalize() throws Throwable {
		try {
			if (connection != null && !connection.isClosed() && res_stmt != null) {
				res_stmt.close();
			}
		} catch (Exception e) {
			log.warn("Problema in chiusura statement", e);
		}
		super.finalize();
	}

	/**
	 * Ritorna la connessione associata la controllo.
	 * 
	 * @return una istanza di tipo <I>Connection</I>.
	 * @throws SQLException
	 *             se viene riscontrato un errore.
	 * @see java.sql.Statement#getConnection()
	 *      java.sql.Statement.getConnection()
	 */
	public Connection getConnection() {
		return connection;
	}

	public void setConnection(Connection conn) {
		connection = conn;
	}

	
	/*
	 * private int executeSTATEMENT(String sql, boolean forcePreparedStatement)
	 * throws SQLException { boolean usePreparedStatement =
	 * (this.getBinds().size()>0); livelloSQL(sql);
	 * 
	 * Statement st=null; PreparedStatement pst=null; updateCount=0; try { if
	 * (usePreparedStatement) { pst = connection.prepareStatement(sql);
	 * 
	 * //...ciclo di valorizzazione di parametri ArrayList lista =
	 * this.getBindList(); for (int i=0; i<lista.size();) { Object bind =
	 * lista.get(i); i++;
	 * 
	 * if (String.class.isInstance(bind)) { pst.setString(i, (String)bind);
	 * pst.toString() } else if (IClob.class.isInstance(bind)) { IClob clob =
	 * (IClob)bind; pst.setCharacterStream(i, clob.getReader(), clob.length());
	 * 
	 * } else { pst.setObject(i, bind);
	 * livelloWarning("Tipologia di bind non gestita: "
	 * +bind.getClass().getName(),null); } } updateCount = pst.executeUpdate();
	 * 
	 * } else { // Utilizzo un "createStatement" st =
	 * connection.createStatement(); updateCount = st.executeUpdate(sql); }
	 * 
	 * 
	 * } finally { if (st!=null) st.close(); if (pst!=null) pst.close(); }
	 * return updateCount; }
	 */

}
