package it.softecspa.kahuna.sql;

import java.sql.ResultSet;
import java.sql.SQLException;

public class SqlWriter extends AbstractSql {

	public SqlWriter() {
		super();
	}

	public SqlWriter(SqlWriter origine) {
		super(origine);
	}

	@Override
	public void reset() {
		sSQL = "";

		sTables = "";
		sWhere = "";
		sValues = "";
		sColumns = "";
		sOptions = "";
	}

	/**
	 * Restituisce il valore impostato come deafult se il resultser restituisce
	 * un valore null
	 * 
	 * @param res
	 *            ResultSet
	 * @param campo
	 *            Valore stringa rappresentante la COLUMN della tabella
	 * @param valore
	 *            Valore di deafult
	 * @return String
	 * @throws SQLException
	 */
	public static String getStringCatchNull(ResultSet res, String campo, String valore) throws SQLException {
		return (res.getString(campo) != null ? res.getString(campo) : valore);
	}

	public static String getStringCatchNull(ResultSet res, int campo, String valore) throws SQLException {
		return (res.getString(campo) != null ? res.getString(campo) : valore);
	}

	/**
	 * Restituisce il valore impostato come deafult se il Resultser restituisce
	 * un valore null
	 * 
	 * @param res
	 *            ResultSet
	 * @param campo
	 *            Valore stringa rappresentante la COLUMN della tabella
	 * @param valore
	 *            Valore di deafult
	 * @return Integer
	 * @throws SQLException
	 */
	public static Integer getIntegerCatchNull(ResultSet res, String campo, Integer valore) throws SQLException {
		return (res.getString(campo) != null ? new Integer(res.getInt(campo)) : valore);
	}

	public static Integer getIntegerCatchNull(ResultSet res, int campo, Integer valore) throws SQLException {
		return (res.getString(campo) != null ? new Integer(res.getInt(campo)) : valore);
	}

	public static Integer getInteger(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Integer(res.getInt(campo)) : null);
	}

	/**
	 * Restituisce il valore impostato come deafult se il Resultser restituisce
	 * un valore null
	 * 
	 * @param res
	 * @param campo
	 * @param valore
	 * @return
	 * @throws SQLException
	 */
	public static Long getLongCatchNull(ResultSet res, String campo, Long valore) throws SQLException {
		return (res.getString(campo) != null ? new Long(res.getLong(campo)) : valore);
	}

	public static Long getLongCatchNull(ResultSet res, int campo, Long valore) throws SQLException {
		return (res.getString(campo) != null ? new Long(res.getLong(campo)) : valore);
	}

	public static Long getLong(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Long(res.getLong(campo)) : null);
	}
	
	
	
	public static Byte getByte(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Byte(res.getByte(campo)) : null);
	}
	
	
	public static Short getShort(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Short(res.getShort(campo)) : null);
	}
	

	public static Boolean getBoolean(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? (res.getInt(campo)==0?Boolean.FALSE:Boolean.TRUE) : null);
	}
	
	/**
	 * Restituisce il valore impostato come deafult se il Resultser restituisce
	 * un valore null
	 * 
	 * @param res
	 *            ResultSet
	 * @param campo
	 *            Valore stringa rappresentante la COLUMN della tabella
	 * @param valore
	 *            Valore di deafult
	 * @return Double
	 * @throws SQLException
	 */
	public static Double getDoubleCatchNull(ResultSet res, String campo, Double valore) throws SQLException {
		return (res.getString(campo) != null ? new Double(res.getDouble(campo)) : valore);
	}

	public static Double getDoubleCatchNull(ResultSet res, int campo, Double valore) throws SQLException {
		return (res.getString(campo) != null ? new Double(res.getDouble(campo)) : valore);
	}

	public static Double getDouble(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Double(res.getDouble(campo)) : null);
	}

	/**
	 * Restituisce il valore impostato come deafult se il Resultser restituisce
	 * un valore null
	 * 
	 * @param res
	 *            ResultSet
	 * @param campo
	 *            Valore stringa rappresentante la COLUMN della tabella
	 * @param valore
	 *            Valore di deafult
	 * @return Float
	 * @throws SQLException
	 */
	public static Float getFloatCatchNull(ResultSet res, String campo, Float valore) throws SQLException {
		return (res.getString(campo) != null ? new Float(res.getFloat(campo)) : valore);
	}

	public static Float getFloatCatchNull(ResultSet res, int campo, Float valore) throws SQLException {
		return (res.getString(campo) != null ? new Float(res.getFloat(campo)) : valore);
	}

	public static Float getFloat(ResultSet res, String campo) throws SQLException {
		return (res.getObject(campo) != null ? new Float(res.getFloat(campo)) : null);
	}
	
}
