package it.softecspa.kahuna.util;

import it.softecspa.kahuna.lang.XString;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.StringTokenizer;

@SuppressWarnings("serial")
public abstract class AbstractVersion implements Serializable {

	final static String VERSION_XML = "version.xml";

	Properties prop;

	int maior;
	int minor;
	int revision;

	private String token;

	private String getPackageName(Class<? extends AbstractVersion> clazz) {
		String name = clazz.getName();
		int index = name.lastIndexOf('.');
		return name.substring(0, index + 1);
	}

	public AbstractVersion() {
		this((File) null);
	}

	AbstractVersion(String risorsa) {
		this(new File(risorsa));
	}

	AbstractVersion(File file) {
		InputStream input = null;
		prop = new Properties();

		try {
			if (file == null) {
				String risorsa = XString.replaceAll(getPackageName(this.getClass()), ".", "/") + VERSION_XML;
				input = this.getClass().getClassLoader().getResourceAsStream(risorsa);
				if (input == null)
					return;

			} else {
				try {
					input = new FileInputStream(file);
				} catch (FileNotFoundException e) {
					input = null;
				}
				if (input == null)
					return;
			}

			// Carico il file di properties
			prop.loadFromXML(input);
		} catch (IOException e) { 
			/* non carico niente */
		}

		try {
			StringTokenizer st = new StringTokenizer(get(), ".");
			maior = Integer.parseInt(st.nextToken());
			minor = Integer.parseInt(st.nextToken());
			revision = Integer.parseInt(st.nextToken());
			
			// Generazione del token 
			String release = getRelease();
			token = get() + "," + getBuild() + (XString.isNotBlankNull(release) ? " " + release : "");
			token = Security.toMD5(token).toLowerCase();
			//
		} catch (Exception e) {
			/* non carico niente */
		}
	}

	public int getMajorVersion() {
		return maior;
	}

	public int getMinorVersion() {
		return minor;
	}

	public int getRevision() {
		return revision;
	}

	public String getRelease() {
		return prop.get("version.release", "").trim();
	}

	/** @deprecated */
	protected boolean isRelease() {
		return "".equals(getRelease());
	}

	public String getInstallation() {
		return prop.get("build.installation", "sviluppo");
	}

	public String get() {
		return prop.get("version.number", "0.0.0");
	}

	public int getBuild() {
		return prop.getInt("build.number", 0);
	}

	public String getBuildDate() {
		return prop.get("build.date", "?-?-? 00:00:00");
	}

	public String toString() {
		String release = getRelease();
		return get() + "," + getBuild() + (XString.isNotBlankNull(release) ? " " + release : "");
	}

	public String token() {
		return token;
	}
}
