package it.softecspa.kahuna.util;

public class C007 {

  /**
   * (nul)   0 0000 0x00
   * (soh)   1 0001 0x01
   * (stx)   2 0002 0x02
   * (etx)   3 0003 0x03
   * (eot)   4 0004 0x04
   * (enq)   5 0005 0x05
   * (ack)   6 0006 0x06
   * (bel)   7 0007 0x07
   * (bs)    8 0010 0x08
   * (ht)    9 0011 0x09
   * (nl)   10 0012 0x0a
   * (vt)   11 0013 0x0b
   * (np)   12 0014 0x0c
   * (cr)   13 0015 0x0d
   * (so)   14 0016 0x0e
   * (si)   15 0017 0x0f
   * (dle)  16 0020 0x10
   * (dc1)  17 0021 0x11
   * (dc2)  18 0022 0x12
   * (dc3)  19 0023 0x13
   * (dc4)  20 0024 0x14
   * (nak)  21 0025 0x15
   * (syn)  22 0026 0x16
   * (etb)  23 0027 0x17
   * (can)  24 0030 0x18
   * (em)   25 0031 0x19
   * (sub)  26 0032 0x1a
   * (esc)  27 0033 0x1b
   * (fs)   28 0034 0x1c
   * (gs)   29 0035 0x1d
   * (rs)   30 0036 0x1e
   * (us)   31 0037 0x1f
   * (sp)   32 0040 0x20
   * !      33 0041 0x21
   * "      34 0042 0x22
   * -------------------------------- Inizio validi ------- 
   * #      35 0043 0x23
   * $      36 0044 0x24
   * %      37 0045 0x25
   * &      38 0046 0x26
   * '      39 0047 0x27
   * (      40 0050 0x28
   * )      41 0051 0x29
   * *      42 0052 0x2a
   * +      43 0053 0x2b
   * ,      44 0054 0x2c
   * -      45 0055 0x2d
   * .      46 0056 0x2e
   * /      47 0057 0x2f
   * 0      48 0060 0x30
   * 1      49 0061 0x31
   * 2      50 0062 0x32
   * 3      51 0063 0x33
   * 4      52 0064 0x34
   * 5      53 0065 0x35
   * 6      54 0066 0x36
   * 7      55 0067 0x37
   * 8      56 0070 0x38
   * 9      57 0071 0x39
   * :      58 0072 0x3a
   * ;      59 0073 0x3b
   * <      60 0074 0x3c
   * =      61 0075 0x3d
   * >      62 0076 0x3e
   * ?      63 0077 0x3f
   * @      64 0100 0x40
   * A      65 0101 0x41
   * B      66 0102 0x42
   * C      67 0103 0x43
   * D      68 0104 0x44
   * E      69 0105 0x45
   * F      70 0106 0x46
   * G      71 0107 0x47
   * H      72 0110 0x48
   * I      73 0111 0x49
   * J      74 0112 0x4a
   * K      75 0113 0x4b
   * L      76 0114 0x4c
   * M      77 0115 0x4d
   * N      78 0116 0x4e
   * O      79 0117 0x4f
   * P      80 0120 0x50
   * Q      81 0121 0x51
   * R      82 0122 0x52
   * S      83 0123 0x53
   * T      84 0124 0x54
   * U      85 0125 0x55
   * V      86 0126 0x56
   * W      87 0127 0x57
   * X      88 0130 0x58
   * Y      89 0131 0x59
   * Z      90 0132 0x5a
   * [      91 0133 0x5b
   * \      92 0134 0x5c
   * ]      93 0135 0x5d
   * ^      94 0136 0x5e
   * _      95 0137 0x5f
   * `      96 0140 0x60
   * a      97 0141 0x61
   * b      98 0142 0x62
   * c      99 0143 0x63
   * d     100 0144 0x64
   * e     101 0145 0x65
   * f     102 0146 0x66
   * g     103 0147 0x67
   * h     104 0150 0x68
   * i     105 0151 0x69
   * j     106 0152 0x6a
   * k     107 0153 0x6b
   * l     108 0154 0x6c
   * m     109 0155 0x6d
   * n     110 0156 0x6e
   * o     111 0157 0x6f
   * p     112 0160 0x70
   * q     113 0161 0x71
   * r     114 0162 0x72
   * s     115 0163 0x73
   * t     116 0164 0x74
   * u     117 0165 0x75
   * v     118 0166 0x76
   * w     119 0167 0x77
   * x     120 0170 0x78
   * y     121 0171 0x79
   * z     122 0172 0x7a
   * {     123 0173 0x7b
   * |     124 0174 0x7c
   * }     125 0175 0x7d
   * ~     126 0176 0x7e
   * -------------------------------- Fine validi ---------
   * (del) 127 0177 0x7f
   */
  
  
  private static final int OPE_Chiaro2Scuro=0;
  private static final int OPE_Scuro2Chiaro=1;

  // Variabili di classe, vettore di caratteri e sua variabile booleana
  private static final int MAX_MATRICE=92;
  private static char VETTORE_BASE [];
  private static char MATRICE_BASE [] []= new char[MAX_MATRICE] [MAX_MATRICE];
  private static final char GAP_INIZIALE='\u0021'; //  un valore esadecimale
  private static boolean bgCaricato;
  // Sono validi tutti i caratteri da # a ~ della tabella ASCII
  // ------------------------------------------------------------------
  private static final String CRIPTA_BASE="Questa_Non_Si_Indovina_1999";

  private String sParolaBase=CRIPTA_BASE;
  private int nCiclo=1;

  /**
   * ...genera soltanto la matrice per la conversione.
   */
  public C007() {
    //Valorizzazione della matrice dei caratteri
    if (!bgCaricato) {
      VETTORE_BASE = new char[MAX_MATRICE];
      VETTORE_BASE[0]=GAP_INIZIALE;
      //System.out.println(VETTORE_BASE[0]);
      for (int i=1; i<MAX_MATRICE;i++) {
        char carattere = (char)(VETTORE_BASE[i-1]+1);
        if (carattere==' ' ||
            carattere=='"' || 
            carattere=='\'') {
          // Escludo i caratteri <black>, ' e " per evitare problemi con le stringhe
          carattere = (char)(carattere+1);
        }
		VETTORE_BASE[i]= carattere;			  
        //System.out.println(VETTORE_BASE[i]);
      }
      for (int i=0; i<MAX_MATRICE;i++) {
        System.arraycopy(VETTORE_BASE,i,MATRICE_BASE [i],0,MAX_MATRICE-i);
        System.arraycopy(VETTORE_BASE,0,MATRICE_BASE [i],MAX_MATRICE-i,i);
        //System.out.println(MATRICE_BASE[i]);
      }
      bgCaricato=true;
    }
  }
  /**
   * Imposta la chiave per la codifica e decodifica.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param chiave  la stringa utilizzata come chiave.
   */
  public C007(String chiave) {
    this();
    this.setChiave(chiave);
  }

  /**
   * Imposta la chiave e la ciclicit per la codifica e decodifica.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param chiave  la stringa utilizzata come chiave.
   * @param ciclo imposta la ciclicit.
   */
  public C007(String chiave, int ciclo) {
    this();
    this.setChiave(chiave);
    this.setCiclo(ciclo);
  }

  /**
   * Imposta la <B>chiave</B> per l'algoritmo di codifica e decodifica.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param valore  la stringa utilizzata come chiave.
   */
  public void setChiave(String valore) {
    if (valore.length() <=5) {
      sParolaBase=CRIPTA_BASE;
    } else {
      sParolaBase=valore;
    }
  }

  /**
   * Ritorna la <B>chiave</B> utilizzata nell'algoritmo di codifica.
   * @return la stringa utilizzata come chiave.
   */
  public String getChiave() {
    return sParolaBase;
  }

  /**
   * Imposta la <B>ciclicit</B> con cui deve essere applicato l'algoritmo di codifica e decodifica.
   * Il valore deve essere <B>maggiore di 0</B>.
   * @param valore  il numero di cicli.
   */
  public void setCiclo(int valore) {
    if (valore<=0) {
      nCiclo=1;
    } else {
      nCiclo=valore;
    }
  }

  /**
   * Ritorna la <B>ciclicit</B> con cui  applicato l'algoritmo di codifica e decodifica.
   * @return un intero contenete il valore.
   */
  public int getCiclo() {
    return nCiclo;
  }

  /**
   * Applica l'algoritmo di codifica utilizzando la chiave precedentemente impostata.
   * @param inChiaro  la stringa da codificare.
   * @return la stringa codificata.
   */
  public String codifica(String inChiaro) {
    if (inChiaro==null) return null;
    String sAppoggio=inChiaro;

    for (int i=0; i<nCiclo; i++) {
      sAppoggio=this.loopCript(OPE_Chiaro2Scuro, i, sAppoggio);
    }
    return sAppoggio;
  }

  /**
   * Applica l'algoritmo di codifica con la chiave indicata.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param inChiaro  la stringa da codificare.
   * @param chiave  la stringa utilizzata come chiave.
   * @return la stringa codificata.
   */
  public String codifica(String inChiaro, String chiave) {
    this.setChiave(chiave);
    return this.codifica(inChiaro);
  }

  /**
   * Applica l'algoritmo di codifica con la chiave e la ciclicit indicata.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * @param inChiaro  la stringa da codificare.
   * @param chiave  la stringa utilizzata come chiave.
   * @param ciclo  il numero di cicli.
   * @return la stringa codificata.
   */
  public String codifica(String inChiaro, String chiave, int ciclo) {
    this.setChiave(chiave);
    this.setCiclo(ciclo);
    return this.codifica(inChiaro);
  }

  /**
   * Applica l'algoritmo di decodifica utilizzando la chiave precedentemente impostata.
   * @param inScuro  la stringa da codificare.
   * @return la stringa decodificata.
   */
  public String decodifica(String inScuro) {
    if (inScuro==null) return null;
    String sAppoggio=inScuro;
    
    for (int i=0; i<nCiclo; i++) {
      sAppoggio=this.loopCript(OPE_Scuro2Chiaro, i, sAppoggio);
    }
    return sAppoggio;    
  }

  /**
   * Applica l'algoritmo di decodifica con la chiave indicata.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param inScuro  la stringa da decodificare.
   * @param chiave  la stringa utilizzata come chiave.
   * @return la stringa decodificata.
   */
  public String decodifica(String inScuro, String chiave) {
    this.setChiave(chiave);
    return this.decodifica(inScuro);
  }

  /**
   * Applica l'algoritmo di decodifica con la chiave indicata.
   * La <B>chiave</B> deve essere pi lunga di 5 caratteri altrimenti viene utilizzata quella di default.
   * Sono validi esclusivamente i caratteri compresi tra il codice ASCII 32 (blank) e l'ASCII 126 (~).
   * @param inScuro  la stringa da decodificare.
   * @param chiave  la stringa utilizzata come chiave.
   * @param ciclo  il numero di cicli.
   * @return la stringa decodificata.
   */
  public String decodifica(String inScuro, String chiave, int ciclo) {
    this.setChiave(chiave);
    this.setCiclo(ciclo);
    return this.decodifica(inScuro);
  }

  // metodi privati utilizzati per la conversione ------------------------------------------------
  private String loopCript(int azione, int ciclo, String messaggio) {
    String sParolaChiara="";
    String sParolaScura="";    
    int riga, colonna;

    if (azione==OPE_Chiaro2Scuro) {
      sParolaChiara=messaggio;
      sParolaScura="";
    } else if (azione==OPE_Scuro2Chiaro) {
      sParolaScura=messaggio;
      sParolaChiara="";
    }

    // Costruisco la parola base per la codifica
    String parola="";
    while (parola.length() < messaggio.length()) {
      parola=parola + sParolaBase + Integer.toString(ciclo).trim();
    }
    
    if (azione==OPE_Chiaro2Scuro) {
      // Applico l'algoritmo di codifica
      for (int i=0;i<messaggio.length();i++) {
        colonna= (int)(parola.toCharArray()[i] - GAP_INIZIALE)  ;
        riga=0;
        while (MATRICE_BASE [riga][colonna] != sParolaChiara.toCharArray()[i]) {
          riga++;
        }
        sParolaScura=sParolaScura + new Character((char)(GAP_INIZIALE + riga));
        //System.out.println(sParolaScura);
      }
      return sParolaScura;

    } else if (azione==OPE_Scuro2Chiaro) {
      // Applico l'algoritmo di decodifica
      
      for (int i=0;i<messaggio.length();i++) {
        colonna= (int)(parola.toCharArray()[i] - GAP_INIZIALE);
        riga= (int)(sParolaScura.charAt(i) - GAP_INIZIALE);
        // Faccio l'incrocio tra la 1. riga e la 1. colonna per trovare il carattere originale
        //System.out.println(riga+","+colonna+" "+sParolaChiara);
        try {
          sParolaChiara=sParolaChiara+MATRICE_BASE [riga][colonna];
        } catch (Exception e) {
          return "";
        }
      }
      return sParolaChiara;
    }
    return "";
  }
  
  public String getVettoreBase() {
    return new String(VETTORE_BASE).toString();
  }
  
/*
  public static void main (String argv[]) {

    C007 c= new C007("wuestanoljjfsdfa");
    System.out.println(c.getChiave());
    System.out.println("Sto codificando \"Massimiliano\"");
    System.out.println(c.codifica("Massimiliano"));
    System.out.println(c.decodifica(c.codifica("Massimiliano")));

  }
*/

}