package it.softecspa.kahuna.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


public final class PropertiesCheck {

  private List<String> checklist; 
  private List<String> errorlist; 
  private boolean error;

  public PropertiesCheck() {
    checklist = new ArrayList<String>();  
    errorlist = new ArrayList<String>(); 
    error=true;
  }
  
  public void add(String campo) {
    if (campo==null) return;    
    checklist.add(campo);
  }
  
  
  public List<String> getChecklist() {
    return checklist;
  }


  public int size() {
    return checklist.size();
  }

  protected boolean check(Properties prop) {
    for (int i=0; i<checklist.size();i++) {
      String campo = (String)checklist.get(i);
      
      if (prop.isNull(campo)) {
        errorlist.add("Mandatory parameter absent: "+campo);
      }
    }
    error=(errorlist.size()>0);
    return !error;
  }

  
  public boolean checked() {
    return !error;
  }

  
  public void list(PrintStream out) {
    for (Iterator<String> i = errorlist.iterator(); i.hasNext();) {
      out.println("- "+i.next());
    }    
  }
  
  public void list(PrintWriter out) {
    for (Iterator<String> i = errorlist.iterator(); i.hasNext();) {
      out.println("- "+i.next());
    }    
  }
  
  
  
}
