package it.softecspa.kahuna.util;

import it.softecspa.kahuna.log.KLogger;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Security {

	static KLogger log = KLogger.getLogger(Security.class);
	
	/**
	 * Esegue la codifica dalla stringa utilizzando l'algoritmo MD5
	 * @param value
	 * @return
	 */
	public static String toMD5(String value) {
		return to("MD5", value);
	}
	
	
	
	
	/**
	 * Esegue la codifica dalla stringa utilizzando l'algoritmo SHA-1
	 * @param value
	 * @return
	 */
	public static String toSHA(String value) {
		return to("SHA", value);
	}
	
	
	
	private static String to(String algorithm, String value) {
		byte[] defaultBytes = value.getBytes();
		
		try{
			MessageDigest md = MessageDigest.getInstance(algorithm);
			md.reset();
			md.update(defaultBytes);
			byte messageDigest[] = md.digest();
		            
			StringBuffer hexString = new StringBuffer();
			for (int i=0;i<messageDigest.length;i++) {
				String hex = Integer.toHexString(0xFF & messageDigest[i]);
				hexString.append((hex.length()==1?"0":"")+hex);
			}
			if (log.isTraceEnabled()) log.trace("Value '"+value+"' "+algorithm+" version is '"+hexString.toString()+"'");
			return ""+hexString;
			
		} catch(NoSuchAlgorithmException e){
		  log.error(e); 
		}
		return null;
	}
	
}
