package it.softecspa.kahuna.util;

/**
 * Semaforo di lancio applicazioni
 * @author m.veroni
 *
 */
public class Semaforo {
	
	private boolean bSemaforo = false;

	/**
	 * Controlla il semaforo
	 * @return
	 */
	public synchronized boolean check() {
		if (bSemaforo) return true;
		bSemaforo = true;
		return false;			
	}
	
	/**
	 * Restituisce TRUE se il semaforo  ROSSO
	 * @return
	 */
	public synchronized boolean isRed() {
		return bSemaforo;
	}
	
	/**
	 * Restituisce TRUE se il semaforo  VERDE
	 * @return
	 */
	public synchronized boolean isGreen() {
		return !bSemaforo;
	}
	
	/**
	 * Reset del semaforo
	 */
	public synchronized void reset() {
		bSemaforo = false;
	}
	
}