// Source File Name:   StringSplitter.java

package it.softecspa.kahuna.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class StringSplitter implements Enumeration<String> {

	public StringSplitter(String str, String delim) {
		this.str = null;
		idx = 0;
		this.delim = null;
		this.str = str;
		this.delim = delim;
	}

	public boolean hasMoreElements() {
		return idx <= str.length();
	}

	public String nextElement() {
		int pos = 0;
		String element = "";
		try {
			if (idx != str.length()) {
				pos = str.indexOf(delim, idx);
				if (pos == -1) {
					element = str.substring(idx);
					idx = str.length() + delim.length();
				} else {
					element = str.substring(idx, pos);
					idx = pos + delim.length();
				}
			} else {
				idx += delim.length();
			}
		} catch (Exception e) {
			throw new NoSuchElementException("No more tokens<" + str + ">");
		}
		return element;
	}

	public String nextToken() {
		return (String) nextElement();
	}

	public int countTokens() {
		int numero = 1;
		for (int indice = -1; (indice = str.indexOf(delim, indice + 1)) != -1;)
			numero++;

		return numero;
	}

	String str;
	int idx;
	String delim;
}
