package it.softecspa.kahuna.util;

import java.text.ParseException;

public class XOR {

	private static final char[] dec2char = {'0','1','2','3','4','5','6','7','8','9','A','B','C','D','E','F'};
	
	public static byte charToHex(char c) throws ParseException {
		
		if (c>='0' && c<='9')
			return (byte)(c-'0');
		else if (c>='A' && c<='F')
			return (byte)(c-'A'+10);
		else if (c>='a' && c<='f')
			return (byte)(c-'a'+10);
		else
			throw new ParseException("Can't Convert to Hex char "+c,0);
	}
	
	public static byte charsToHex(char c1,char c2) throws ParseException {
		
		return (byte)((charToHex(c1)<<4) + charToHex(c2));		
	}
	
	public static byte[] charsToByte(byte[] src) throws ParseException {
		
		if (src == null)
			throw new ParseException("charsToByte:null src",0);
		
		byte[] dest = new byte[src.length];
		for (int i=0;i<src.length;i++)
			dest[i]=(byte)(src[i]-'0');
		
		return dest;
	}

	public static byte[] hex2byte(String key) throws ParseException {
		
		if (key == null)
			throw new ParseException("hex2byte:String null",0);
		
		int length = key.length();	
		if (length %2 != 0)
			throw new ParseException("hex2byte:Sorry can convert only even number of chars",0);
		
		try{
			
			int i=0;					
			byte[] out = new byte[length/2];

			for(i=0;i<length/2;i++) {

				//byte hi = charToHex(key.charAt(i*2));
				//byte lo = charToHex(key.charAt(i*2+1));
				
				out[i] = charsToHex(key.charAt(i*2),key.charAt(i*2+1));//(byte)((hi<<4) + lo);			
			}
						
			return out; 
		}catch(Exception e){
			throw new ParseException(e.getMessage(),0);
		}
	}
	
	public static String byte2hex(byte[] in,int offset,int len) throws ParseException {		
		/* Trasformazione in String */
		if (in == null){
			throw new ParseException("byte2hex:byte array  null",0);
		}
		
		try{
			String out = "";
		    for(int j=offset;j<offset+len;j++){
		    	byte lo = (byte)(in[j] & 0x0F);
			    byte hi = (byte)((in[j] & 0xF0)>>4);
			    out += dec2char[hi];
			    out += dec2char[lo];
		    }
			return out;
		}catch(Exception e){
			throw new ParseException(e.getMessage(),0);
		}
	}
	
	public static String byte2hex(byte[] in) throws ParseException {		
		/* Trasformazione in String */
		if (in == null){
			throw new ParseException("byte2hex:byte array  null",0);
		}
		
		return byte2hex(in,0,in.length);
	}
	
	public static byte[] xor(byte[] a, byte[] b) throws ParseException {
		
		if(a == null || b == null){
			throw new ParseException("XOR:byte array null",0);
		}
		if ( a.length != b.length){
			throw new ParseException("XOR:byte arrays different length",0);
		}
		
		try{						
			byte[] out = new byte[a.length];
			for(int i=0;i<a.length;i++)
				out[i]=(byte)(a[i]^b[i]);
			
			return out;
		}catch(Exception e){
			throw new ParseException(e.getMessage(),0);
		}
	}
	
	public String xor(String a, String b) throws ParseException {
		
		byte[] out = xor(hex2byte(a),hex2byte(b));
		return byte2hex(out);
		
	}
	/*
	public static void main(String[] args) throws Exception {		
		XOR operazione = new XOR();
		//String out = operazione.xor("379E7F08B532B3648AA27C5BFB16CE9E", "FE8AB337D0CD297079384FFB3D37677A");
		//System.out.println(out);
		
		byte[] data = operazione.hex2byte("0123456789abcDEF");
		for (int i=0;i<data.length;i++)
			System.out.printf("[%d],%x\n",i,data[i]);
		
	}
  */
}
