package it.softecspa.kahuna.util.calendar;

import java.util.Calendar;
import java.util.Locale;


@SuppressWarnings("serial")
public class EnterpriseCalendarIT extends EnterpriseCalendar {
	
	static private int[][] festiviITA = new int[][] { { 1, 1 } // Capodanno
			, { 1, 6 } 		// Epifania
			, { 4, 25 } 	// 25 Aprile
			, { 5, 1 } 		// 1 Maggio
			, { 6, 2 } 		// 2 Giugno
			, { 8, 15 } 	// Ferragosto (Assunzione di Maria)
			, { 11, 1 } 	// 1 Novembre
			, { 12, 8 } 	// 8 Dicembre
			, { 25, 12 } 	// Natale
			, { 26, 12 } }; // S.Stefano

	
	public static final String PATTERN_CANONICAL_IT = "dd/MM/yyyy HH:mm.ss";
	
	
	public EnterpriseCalendarIT() {
		super();
	}
	
	
	EnterpriseCalendarIT(EnterpriseCalendar value) {
		super(value);
	}


	public String formatCanonicalIT() {
		return this.format(PATTERN_CANONICAL_IT, Locale.ITALY);
	}
	
	
	/** @deprecated */
	static public int confrontaGiorno(Calendar primo, Calendar secondo) {
		// 0 = date uguali
		// 1 = primo > secondo
		// 2 = primo < secondo
		long g1 = ((primo.get(YEAR) * 100 + primo.get(MONTH) + 1) * 100)
				+ primo.get(DAY_OF_MONTH);
		long g2 = ((secondo.get(YEAR) * 100 + secondo.get(MONTH) + 1) * 100)
				+ secondo.get(DAY_OF_MONTH);
		if (g1 < g2)
			return 2;
		if (g1 > g2)
			return 1;
		return 0;
	}

	/** @deprecated */
	static public int confrontaGiornoOra(Calendar primo, Calendar secondo) {
		// 0 = date uguali
		// 1 = primo > secondo
		// 2 = primo < secondo
		double anno = primo.get(YEAR);
		double mese = (anno * 100) + primo.get(MONTH) + 1;
		double giorno = (mese * 100) + primo.get(DAY_OF_MONTH);
		double ore = (giorno * 100) + primo.get(HOUR_OF_DAY);
		double minuti = (ore * 100) + primo.get(MINUTE);
		double g1 = (minuti * 100) + primo.get(SECOND);
		// System.out.println(g1);

		anno = secondo.get(YEAR);
		mese = (anno * 100) + secondo.get(MONTH) + 1;
		giorno = (mese * 100) + secondo.get(DAY_OF_MONTH);
		ore = (giorno * 100) + secondo.get(HOUR_OF_DAY);
		minuti = (ore * 100) + secondo.get(MINUTE);
		double g2 = (minuti * 100) + secondo.get(SECOND);
		// System.out.println(g2);

		if (g1 < g2)
			return 2;
		if (g1 > g2)
			return 1;
		return 0;
	}

	
	
	public static String getMonthNameIT(int mese) {		
		switch (mese) {
		case 1:
			return "gennaio";
		case 2:
			return "febbraio";
		case 3:
			return "marzo";
		case 4:
			return "aprile";
		case 5:
			return "maggio";
		case 6:
			return "giugno";
		case 7:
			return "luglio";
		case 8:
			return "agosto";
		case 9:
			return "settembre";
		case 10:
			return "ottobre";
		case 11:
			return "novembre";
		case 12:
			return "dicembre";
		}

		return null;
	}

	
	

	public static String getPeriod(EnterpriseCalendarIT inizio, EnterpriseCalendarIT fine) {
		if (inizio == null && fine == null)
			return "";

		String s = "";
		boolean stessoAnno = false;
		boolean stessoMese = false;
		boolean stessoGiorno = false;
		if (inizio != null && fine != null) {
			if (inizio.get(EnterpriseCalendarIT.YEAR) == fine.get(EnterpriseCalendarIT.YEAR)) {
				stessoAnno = true;
				if (inizio.get(EnterpriseCalendarIT.MONTH) == fine.get(EnterpriseCalendarIT.MONTH)) {
					stessoMese = true;
					if (inizio.get(EnterpriseCalendarIT.DAY_OF_MONTH) == fine
							.get(EnterpriseCalendarIT.DAY_OF_MONTH)) {
						stessoGiorno = true;
					}
				}
			}

			// System.out.println(stessoAnno);
			// System.out.println(stessoMese);
			// System.out.println(stessoGiorno);
			if (stessoAnno && stessoMese && stessoGiorno) {
				s = "il " + inizio.format("dd/MM/yyyy");
			} else if (stessoAnno && stessoMese) {
				s = "dal " + inizio.format("dd") + " al " + fine.format("dd")
						+ " " + getMonthNameIT(inizio.get(EnterpriseCalendarIT.MONTH) + 1) + " "
						+ inizio.format("yyyy");
			} else if (stessoAnno) {
				s = "dal " + inizio.format("dd/MM") + " al "
						+ fine.format("dd/MM") + " " + inizio.format("yyyy");
			} else {
				s = "dal " + inizio.format("dd/MM/yyyy") + " al "
						+ fine.format("dd/MM/yyyy");
			}
		} else {
			if (inizio != null) {
				s = "dal " + inizio.format("dd/MM/yyyy");
			} else if (fine != null) {
				s = "al " + fine.format("dd/MM/yyyy");
			}
		}
		return s;
	}

		
	
	public boolean isPeriodoNatale() {
		return isPeriodoNatale(8, 6);
	}

	public boolean isPeriodoNatale(int dicembre, int gennaio) {
		return (this.get(MONTH) == DECEMBER && this.get(DAY_OF_MONTH) >= dicembre)
				|| (this.get(MONTH) == JANUARY && this.get(DAY_OF_MONTH) <= gennaio);
	}	

	
	public static boolean isFestivo(EnterpriseCalendarIT data) {
		// La Domenica  giorno festivo
		int week = data.get(DAY_OF_WEEK);
		if (week == SUNDAY)
			return true;

		// Verifica festivit canonica
		int mese = data.get(MONTH) + 1;
		int giorno = data.get(DAY_OF_MONTH);
		for (int i = 0; i < festiviITA.length; i++) {
			if (festiviITA[i][0] == mese) {
				if (festiviITA[i][1] == giorno) {
					return true;
				}
			}
		}

		// Verifica Pasqua
		EnterpriseCalendar pasqua = EnterpriseCalendar.easter(data.get(YEAR));
		if (pasqua.getMonth() == mese) {
			if (pasqua.getDay() == giorno) {
				return true;
			}
		}

		// Verifica Luned dell'Angelo
		pasqua.add(DAY_OF_MONTH, 1);
		if (pasqua.getMonth() == mese) {
			if (pasqua.getDay() == giorno) {
				return true;
			}
		}

		return false;
	}

	public boolean isFestivo() {
		return isFestivo(this);
	}
	 
	public static boolean isFeriale(EnterpriseCalendarIT data) {
		return !isFestivo(data);
	}

	public boolean isFeriale() {
		return !isFestivo(this);
	}
	

	
	public static boolean isLavorativo(EnterpriseCalendarIT data) {
		int week = data.get(DAY_OF_WEEK);

		// Se Sabato non si lavora
		if (week == SATURDAY)
			return false;

		return !isFestivo(data);
	}

	public boolean isLavorativo() {
		return isLavorativo(this);
	}
	

	/* *
	 * Restituisce il primo giorno lavorativo dopo la data specificata
	 * 
	 * @param data
	 * @return
	 * /
	public static Kalendario getFirstLavorativoAfter(GregorianCalendar data) {
		Kalendario confronto = newInstance(data);
		if (confronto == null)
			return null;

		do {
			confronto.add(DAY_OF_MONTH, 1);
			// int week = confronto.getWeek();
			// if (week!=SUNDAY) {confronto.add(DAY_OF_MONTH, 1); continue;}
			// if (week!=SATURDAY) {confronto.add(DAY_OF_MONTH, 1); continue;}
			if (!confronto.isLavorativo())
				continue;

			return confronto;
		} while (true);
	}

	public Kalendario getFirstLavorativoAfter() {
		return getFirstLavorativoAfter(this);
	}
	*/

	
	/**
	 * Descrizione del'intervallo
	 * 
	 * @param secondi
	 * @return
	 */
	public static String descrizioneIntervallo(long secondi) {
		// Calcolo della durata esperessa in secondi
		String durata = "";
		if (secondi == 0) {
			durata += "<1 secondo";
		} else if (secondi == 1) {
			durata += secondi + " secondo";
		} else if (secondi < 60) {
			durata += secondi + " secondi";
		} else {
			long mm = (secondi / 60);
			long ss = (secondi % 60);
			if (mm == 1) {
				durata += mm + " minuto";
			} else if (mm < 60) {
				durata += mm + " minuti";
			} else {
				long hh = (mm / 60);
				mm = mm % 60;
				durata += hh + " ore, " + mm + " minut" + (mm == 1 ? "o" : "i");
			}
			durata += " e " + ss + " second" + (ss == 1 ? "o" : "i");
		}
		return durata;
	}

	
}