package it.softecspa.kahuna.util.calendar;


import it.softecspa.kahuna.lang.XString;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

@SuppressWarnings("serial")
public class EnterpriseCalendarUTC extends KahunaCalendar<EnterpriseCalendarUTC> {

	
		
	public EnterpriseCalendarUTC() {
		super(UTC);		
	}
	
	public EnterpriseCalendarUTC(int year, int month, int day) {
		super(UTC, year, month, day, UTC);		
	}

	public EnterpriseCalendarUTC(int year, int month, int day, int hour, int minute) {
		super(UTC, year, month, day, hour, minute, UTC);
	}

	public EnterpriseCalendarUTC(int year, int month, int day, int hour, int minute, int second) {
		super(UTC, year, month, day, hour, minute, second, UTC);
	}

	/*
	public EnterpriseCalendarUTC(String value, String pattern) throws Exception {
		super(UTC, value, pattern);		
	}
	*/
		
	public EnterpriseCalendarUTC(String value, String ... patterns) throws Exception {
		super(UTC, value, patterns);
	}
		
	public EnterpriseCalendarUTC(Timestamp data) {
		super(UTC, data);
	}
	
	public EnterpriseCalendarUTC(java.util.Date data) {
		super(UTC, data);
	}
	
	public EnterpriseCalendarUTC(java.sql.Date data) {
		super(UTC, data);
	}
	
	public EnterpriseCalendarUTC(Calendar calendar) {
		super(UTC, calendar);
	}
	
	public EnterpriseCalendarUTC(long millis) {
		super(UTC, millis);
	}
	
	
	
	public static EnterpriseCalendarUTC now() {
		EnterpriseCalendarUTC now = new EnterpriseCalendarUTC();				
		return now;
	}
		
	public static EnterpriseCalendarUTC today() {
		EnterpriseCalendarUTC adesso = EnterpriseCalendarUTC.now();
		return new EnterpriseCalendarUTC(adesso.getYear(), adesso.getMonth(), adesso.getDay(), 0, 0, 0);
	}
	
	public static EnterpriseCalendarUTC tonight() {
		EnterpriseCalendarUTC adesso = EnterpriseCalendarUTC.now();
		return new EnterpriseCalendarUTC(adesso.getYear(), adesso.getMonth(), adesso.getDay(), 23, 59, 29);
	}
	
	public static EnterpriseCalendarUTC yesterday() {
		EnterpriseCalendarUTC adesso = EnterpriseCalendarUTC.now();
		return new EnterpriseCalendarUTC(adesso.getYear(), adesso.getMonth(), adesso.getDay() - 1, 0, 0, 0);
	}

	public static EnterpriseCalendarUTC tomorrow() {
		EnterpriseCalendarUTC adesso = EnterpriseCalendarUTC.now();
		return new EnterpriseCalendarUTC(adesso.getYear(), adesso.getMonth(), adesso.getDay() + 1, 0, 0, 0);
	}

	
	public static EnterpriseCalendarUTC futureDay(int days) {
		EnterpriseCalendarUTC adesso = EnterpriseCalendarUTC.now();
		return new EnterpriseCalendarUTC(adesso.getYear(), adesso.getMonth(), adesso.getDay() + days, 0, 0, 0);
	}

	
	public static EnterpriseCalendarUTC newInstance(Object valore) {
		if (valore == null)
			return null;

		if (valore instanceof Timestamp) {
			return newInstance((Timestamp) valore);
		} else if (valore instanceof java.util.Date) {
			return newInstance((java.util.Date) valore);
		} else if (valore instanceof java.sql.Date) {
			return newInstance((java.sql.Date) valore);
		} else if (valore instanceof Time) {
			return newInstance((Time) valore);
		} else if (valore instanceof Calendar) {
			return newInstance((Calendar) valore);
		} else if (valore instanceof Long) {
			return newInstance((Long) valore);
		}
		return null;
	}

	public static EnterpriseCalendarUTC newInstance(Object valore, TimeZone zone) {
		if (valore == null)
			return null;

		if (valore instanceof Timestamp) {
			return newInstance((Timestamp) valore);
		} else if (valore instanceof java.util.Date) {
			return newInstance((java.util.Date) valore);
		} else if (valore instanceof java.sql.Date) {
			return newInstance((java.sql.Date) valore);
		} else if (valore instanceof Time) {
			return newInstance((Time) valore);
		} else if (valore instanceof Calendar) {
			return newInstance((Calendar) valore);
		} else if (valore instanceof Long) {
			return newInstance((Long) valore);
		}
		return null;
	}
	
	public static EnterpriseCalendarUTC newInstance(Long valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	public static EnterpriseCalendarUTC newInstance(Timestamp valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	public static EnterpriseCalendarUTC newInstance(java.util.Date valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	public static EnterpriseCalendarUTC newInstance(java.sql.Date valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	public static EnterpriseCalendarUTC newInstance(Time valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	public static EnterpriseCalendarUTC newInstance(Calendar valore) {
		return valore != null ? new EnterpriseCalendarUTC(valore) : null;
	}

	
	public static EnterpriseCalendarUTC newInstance(String valore, String formato) throws Exception {
		return XString.isNotBlankNullTrim(valore) ? new EnterpriseCalendarUTC(valore, formato) : null;
	}
	
	public static EnterpriseCalendarUTC newInstance(String valore, String[] formati) throws Exception {
		return XString.isNotBlankNullTrim(valore) ? new EnterpriseCalendarUTC(valore, formati) : null;
	}

	
	
	
	@Override
	public EnterpriseCalendarUTC getMidnight() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public EnterpriseCalendarUTC getDatePart() {
		// TODO Auto-generated method stub
		return null;
	}


	
}