package it.softecspa.kahuna.util.toextends;

import it.softecspa.kahuna.io.File;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class XMLNodeUtility {

	/**
	 * Parses an XML file and returns a DOM document.
	 */
	protected Document getDocument(File file) throws Exception {
		return getDocument(file, true);
	}
	
	protected Document getDocument(File file, boolean validate) throws Exception {
		try {
			DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();			
			DocumentBuilder builder = factory.newDocumentBuilder();
			
			if (!validate) {
				builder.setEntityResolver(new EntityResolver() {			      
			        public InputSource resolveEntity(String publicId, String systemId)
			                throws SAXException, IOException {
			                return new InputSource(new StringReader(""));
			            
			        }
			    });
			}
			
			return builder.parse(file);
		} catch (SAXException e) {
			throw new Exception("SAXException open file '"+file.getAbsolutePath()+"'", e);			
		} catch (ParserConfigurationException e) {
			throw new Exception("ParserConfigurationException open file '"+file.getAbsolutePath()+"'", e);
		} catch (IOException e) {
			throw new Exception("IOException open file '"+file.getAbsolutePath()+"'", e);
		}
	}
	
	
	protected boolean checkElementNode(Node node, String name) {
		return node.getNodeType() == Node.ELEMENT_NODE &&
			   node.getNodeName().equalsIgnoreCase(name);
	}
	
	protected String getNodeValue(Node node) {
		// ...nodo vuoto
		if (node.getFirstChild()==null) return null;
		// ...nodo con valore
		String value = node.getFirstChild().getNodeValue();
		if (value==null || 
			value.trim().equals("")) return null;
		return value; 
	}
	
	protected String getAttributeValue(NamedNodeMap attributi, String name) {
		if (attributi==null) return null;
		Node node = attributi.getNamedItem(name);
		if (node!=null) return node.getNodeValue();
		return null;
	}
	
	

	protected String getAttributeValue(NamedNodeMap attributi, String name, String _default) {
		String value = getAttributeValue(attributi, name);
		if (value==null) return _default;
		return value;
	}
}
