package it.softecspa.kahuna.util.xml;
public enum NodeType {
	
		/**
	     * Uncknown.
	     */
	    UNCKNOWN((short)0)
	    
		/**
	     * The node is an <code>Element</code>.
	     */
	   , ELEMENT_NODE((short)1)
	    /**
	     * The node is an <code>Attr</code>.
	     */
	   , ATTRIBUTE_NODE((short)2)
	    /**
	     * The node is a <code>Text</code> node.
	     */
	   , TEXT_NODE((short)3)
	    /**
	     * The node is a <code>CDATASection</code>.
	     */
	   , CDATA_SECTION_NODE((short)4)
	    /**
	     * The node is an <code>EntityReference</code>.
	     */
	   , ENTITY_REFERENCE_NODE((short)5)
	    /**
	     * The node is an <code>Entity</code>.
	     */
	   , ENTITY_NODE((short)6)
	    /**
	     * The node is a <code>ProcessingInstruction</code>.
	     */
	   , PROCESSING_INSTRUCTION_NODE((short)7)
	    /**
	     * The node is a <code>Comment</code>.
	     */
	   , COMMENT_NODE((short)8)
	    /**
	     * The node is a <code>Document</code>.
	     */
	   , DOCUMENT_NODE((short)9)
	    /**
	     * The node is a <code>DocumentType</code>.
	     */
	   , DOCUMENT_TYPE_NODE((short)10)
	    /**
	     * The node is a <code>DocumentFragment</code>.
	     */
	   , DOCUMENT_FRAGMENT_NODE((short)11)
	    /**
	     * The node is a <code>Notation</code>.
	     */
	   , NOTATION_NODE((short)12);
	    
	    
		
		private short value;
		
		private NodeType(short value) {
			this.value = value;
		}

		public short getValue() {
			return value;
		}
	    
	}