package it.softecspa.kahuna.util.xml;

import it.softecspa.kahuna.lang.XString;

/**
 * Classe  per la gestione automatica di file XML
 * 
 * @author m.veroni
 *
 */
public class XmlAttribute <K> {

	protected String attributeName;
	protected K attributeValue;	
	
	
	public XmlAttribute(String attributeName) {
		this.attributeName = (XString.isNotBlankNull(attributeName)?attributeName.trim():null);
	}

	
	public K getValue() {
		return attributeValue;
	}

	public void setValue(K attributeValue) {
		this.attributeValue = attributeValue;
	}

	
	public String getName() {
		return attributeName;
	}

	
	public static <K> K getValue(XmlAttribute<K> attribute) {
		return (attribute!=null?attribute.getValue():null);
	}	
		
	
	
	
}
