package it.softecspa.kahuna.util.xml;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

import org.w3c.dom.NodeList;

@SuppressWarnings("serial")
public class XmlList<T extends XmlElement> extends ArrayList<T> {

	private boolean hideIfEmpty;
	protected String name;
	
	
	public XmlList(String name) {		
		this(name,true);
	}

	public XmlList(String name, boolean hideIfEmpty) {		
		this.name = name;
		this.hideIfEmpty = hideIfEmpty;
	}
	
	public XmlList(String name, int initialCapacity) {
		super(initialCapacity);
		this.name = name;
	}
	
	
	public String getName() {
		return name;
	}

	protected void setName(String name) {
		this.name = name;
	}

	
	private T newInstance(Class<T> clazz) throws XmlParserException {
		
		// Costruisco la classe;
		Constructor<T> costructor=null;
		try {
			costructor = clazz.getConstructor();
		} catch (SecurityException e) {
			throw new XmlParserException("SecurityException with class costructor for "+clazz,e);
		} catch (NoSuchMethodException e) {
			throw new XmlParserException("NoSuchMethodException with class costructor for "+clazz+"; do not use InnerClass", e);
		}
		
		try {
			return (T)costructor.newInstance();
		} catch (IllegalArgumentException e) {
			throw new XmlParserException("IllegalArgumentException with class costructor for "+clazz+"; do not use InnerClass", e);
		} catch (InstantiationException e) {
			throw new XmlParserException("InstantiationException with class costructor for "+clazz, e);
		} catch (IllegalAccessException e) {
			throw new XmlParserException("IllegalAccessException with class costructor for "+clazz, e);
		} catch (InvocationTargetException e) {
			throw new XmlParserException("InvocationTargetException with class costructor for "+clazz, e);
		}
	}
	
	
	
	public void parseList(NodeElement node, Class<T> clazz) throws XmlParserException {
		NodeList list = node.getChilds();
		if (list.getLength()==0) return;
		
		T bean = null;
		for (int i=0; i<list.getLength(); i++) {
			
			if (i==0) {
				
			}			
			if (bean==null) {
				bean = newInstance(clazz);
			}
			
			NodeElement element = NodeElement.getInstance(list.item(i),bean.getEntityName());
			if (element!=null) {
				bean.parse(element);
				add(bean);
				bean = null;
			}
			
		}
		
	}

	protected boolean hideIfEmpty() {
		return hideIfEmpty;
	}
	
}
