package it.softecspa.kahuna.util.xml;


@SuppressWarnings("serial")
public class XmlParserException extends Throwable {

	
	public XmlParserException(XmlElement element) {
		super("XML element '"+element.getEntityName()+"' is empty or not valid");
	}
	
	public XmlParserException(XmlElement element, Throwable cause) {
		super("XML element '"+element.getEntityName()+"' not valid:" +cause.toString());
	}
	
	public XmlParserException(NodeElement nodeElement, String attribute, Class<?> clazz) {
		super("XML attribute '"+attribute+"' for element '"+nodeElement.get().getNodeName()+"' is empty or not valid ("+clazz.getSimpleName()+")");
	}
	
	public XmlParserException(String message, Throwable cause) {
		super(message, cause);
	}
	
	public XmlParserException(Throwable cause) {
		super(cause.toString(), cause);
	}
	
	public XmlParserException(String message) {
		super(message);
	}
	
	

	/**
	 * Return TRUE se l'errore  stato scatenato da una altra eccezione
	 * @return
	 */
	public boolean isGrave() {
		return (getCause()!=null);
	}
	
}
