/*
 * Copyright 2010 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 * 
 *  http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */
package com.amazonaws.services.rds.model;

/**
 * D B Engine Version
 */
public class DBEngineVersion {

    private String engine;

    private String engineVersion;

    private String dBParameterGroupFamily;

    /**
     * Default constructor for a new DBEngineVersion object.  Callers should use the
     * setter or fluent setter (with...) methods to initialize this object after creating it.
     */
    public DBEngineVersion() {}
    
    /**
     * Returns the value of the Engine property for this object.
     *
     * @return The value of the Engine property for this object.
     */
    public String getEngine() {
        return engine;
    }
    
    /**
     * Sets the value of the Engine property for this object.
     *
     * @param engine The new value for the Engine property for this object.
     */
    public void setEngine(String engine) {
        this.engine = engine;
    }
    
    /**
     * Sets the value of the Engine property for this object.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param engine The new value for the Engine property for this object.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DBEngineVersion withEngine(String engine) {
        this.engine = engine;
        return this;
    }
    
    
    /**
     * Returns the value of the EngineVersion property for this object.
     *
     * @return The value of the EngineVersion property for this object.
     */
    public String getEngineVersion() {
        return engineVersion;
    }
    
    /**
     * Sets the value of the EngineVersion property for this object.
     *
     * @param engineVersion The new value for the EngineVersion property for this object.
     */
    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }
    
    /**
     * Sets the value of the EngineVersion property for this object.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param engineVersion The new value for the EngineVersion property for this object.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DBEngineVersion withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }
    
    
    /**
     * Returns the value of the DBParameterGroupFamily property for this
     * object.
     *
     * @return The value of the DBParameterGroupFamily property for this object.
     */
    public String getDBParameterGroupFamily() {
        return dBParameterGroupFamily;
    }
    
    /**
     * Sets the value of the DBParameterGroupFamily property for this object.
     *
     * @param dBParameterGroupFamily The new value for the DBParameterGroupFamily property for this object.
     */
    public void setDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.dBParameterGroupFamily = dBParameterGroupFamily;
    }
    
    /**
     * Sets the value of the DBParameterGroupFamily property for this object.
     * <p>
     * Returns a reference to this object so that method calls can be chained together.
     *
     * @param dBParameterGroupFamily The new value for the DBParameterGroupFamily property for this object.
     *
     * @return A reference to this updated object so that method calls can be chained 
     *         together. 
     */
    public DBEngineVersion withDBParameterGroupFamily(String dBParameterGroupFamily) {
        this.dBParameterGroupFamily = dBParameterGroupFamily;
        return this;
    }
    
    
    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("Engine: " + engine + ", ");
        sb.append("EngineVersion: " + engineVersion + ", ");
        sb.append("DBParameterGroupFamily: " + dBParameterGroupFamily + ", ");
        sb.append("}");
        return sb.toString();
    }
    
}
    