package it.softecspa.s4fs;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.model.Region;

public class S4Bucket {
	
	private Integer uid;
	
	private String name;
	private Region region;
		
	private AWSCredentials credentials;
	
	 
	public S4Bucket(String name, AWSCredentials credentials, Region region) {
		this.name = name;
		this.credentials = credentials;
		this.region = region;
	}
	
	
	public S4Bucket(String name, String accessKey, String secretKey, Region region) {
		this(name, new BasicAWSCredentials(accessKey, secretKey), region);
	}


	public String getName() {
		return name;
	}


	public Region getRegion() {
		return region;
	}


	public AWSCredentials getCredentials() {
		return credentials;
	}

	
	
	public Integer getUid() {
		return uid;
	}

	void setUid(Integer uid) {
		this.uid = uid;
	}
	
	
	
	
	
}
