package it.softecspa.s4fs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;


@SuppressWarnings("serial")
public class S4Exception extends Throwable {
	
	private int statusCode;
	
	public S4Exception(S4Status status, Throwable e) {
		super(status.getMessage(),e);
		this.statusCode = status.getValue();
	}
	
	public S4Exception(S4Status status) {
		super(status.getMessage());
		this.statusCode = status.getValue();
	}

		
	public S4Exception(S4Status status, String message) {
		super(status.getMessage()+message);
		this.statusCode = status.getValue();
	}
	
	
	public S4Exception(AmazonServiceException ase) {
		super("Caught an AmazonServiceException, which means your request made it" +
		      " to Amazon S3, but was rejected with an error response for some reason: \n" +
			  "\t- Error Message:    " + ase.getMessage() + "\n" +
			  "\t- HTTP Status Code: " + ase.getStatusCode() + "\n" +
			  "\t- AWS Error Code:   " + ase.getErrorCode() + "\n" +
			  "\t- Error Type:       " + ase.getErrorType() + "\n" +
			  "\t- Request ID:       " + ase.getRequestId(), ase);
		this.statusCode = S4Status.AMAZON_SERVICE_EXCEPTION.getValue()+ase.getStatusCode();		
	}
	
	public S4Exception(AmazonClientException ace) {
		super("Caught an AmazonClientException, which means the client encountered" +
			  " a serious internal problem while trying to communicate with S3," +
			  " such as not being able to access the network: \n" +
			  "\t- Error Message:    " + ace.getMessage(), ace);
		this.statusCode = S4Status.AMAZON_CLIENT_EXCEPTION.getValue();	
	}
	
	

	public int getStatusCode() {
		return this.statusCode;
	}

	public void setStatus(S4Status status) {
		this.statusCode = status.getValue();
	}

	
}
