package it.softecspa.s4fs;

import it.softecspa.s4fs.vfat.FileS4;
import it.softecspa.s4fs.vfat.WritePolicy;

public enum S4Status {
		// Messaggi restituiti dal servizio notifiche
		  AMAZON_SERVICE_EXCEPTION		(10000,"Amazon Service Exception")
		, AMAZON_CLIENT_EXCEPTION		(10000,"Amazon Client Exception") 
		
		, CONFIGURATION_PROBLEM			(90999,S4Engine.class.getSimpleName() +" is not correctly configured")
		, FIELD_MANDATORY				(90998,"Field mandatory")
		
		, VFAT_EXCEPTION				(90900,"VFAT Exception")
		, SQL_EXCEPTION					(90901,"SQL Exception") 
		, UNHANDLED_EXCEPTION			(90902,"Unhandled Exception")
		
		
		, CHECK_OWNER					(90800,"Problem acquiring owner uid")
		, CHECK_VFAT					(90801,"Problem checking virtual FAT")
		, CHECK_BUCKET					(90802,"Problem acquiring bucket info")
		, SAVE_BUCKET					(90803,"Problem saving bucket info")
		
		, UNUSABLE_POLICY				(90806,"Unusable policy, configure Amazon S3 parameters")
		, IMPOSSIBLE_DOWNLOAD			(90807,"Impossible download, configure Amazon S3 parameters")
		, IMPOSSIBLE_UPLOAD				(90808,"Impossible upload, configure Amazon S3 parameters")
		
		
		, SOURCE_FILE_DONOT_EXIST		(90812,"Source file do not exists")
		, SOURCE_FILE_COPY_ERROR		(90813,"Source file copy error")
		
		
		, REAL_FILE_NULL				(90819,"Not valid object; real file is null")
		, REAL_FILE_NOT_EXIST			(90820,"Not valid object; real file do not exists")
		, REAL_FILE_NOT_FOUND			(90821,"Real file not found in S3 download")		
		, REAL_FILE_WRITE_ERROR			(90822,"Error writing real file in S3 download")
		, REAL_FILE_NOT_USE_S3			(90823,FileS4.class.getSimpleName() +" do not use Amazon S3 storage")		
		
		, FILE_NOT_WRITABLE				(90830,FileS4.class.getSimpleName() +" "+WritePolicy.class.getSimpleName()+" not valid: use "+WritePolicy.UPDATABLE)
		, FILE_IN_DRAFT_MODE			(90831,FileS4.class.getSimpleName() +" in DRAFT mode, operation non permitted")
		, FILE_EXPIRATION_SETUP			(90832,"Error setting file expiration")
		
		, FILE_IS_CLOSED				(90820,FileS4.class.getSimpleName() +" is closed!")
		
		, ACQUIRING_LOCK_HANDLE			(90825,"Error acquiring lock handle")
		
		// Esito positivo (CLASSE 0)
		, OK(0,"Ok"), 
		
		
		// Warning, CLASSE 100
		
		
		;
	
		  
	private int value;
	private String message;
	
	
	private S4Status(int value, String message) {
		this.value = value;
		this.message = message;
	}

	public int getValue() {
		return value;
	}

	public String getMessage() {
		return message;
	}

		
}
