package it.softecspa.s4fs.vfat;

import it.softecspa.database.dbconnect.DatabaseStatementUnplugged;

import java.sql.SQLException;

import org.apache.log4j.Logger;

import com.mysql.jdbc.MysqlErrorNumbers;



abstract class Autocreate {

	Logger log = Logger.getLogger(getClass());
	
	
	abstract public String getTableName();
	
	abstract String createSQL();
	
	
	void checkAndCreate(DatabaseStatementUnplugged dbsu, SQLException e) throws SQLException {
		if (e.getErrorCode()!=MysqlErrorNumbers.ER_NO_SUCH_TABLE) {
			throw e;
		}
		
		// Creo la nuova tabella
		try {
			dbsu.execute(createSQL());
			log.info("New table '" + getTableName() + "' created");
		} catch (SQLException ec) {
			log.fatal("Problem in create table '" + getTableName() + "': "+ec.toString());			
			throw e;
		}		
	}
}
