package it.softecspa.s4fs.vfat;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatementUnplugged;
import it.softecspa.database.dbconnect.Query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;

/**
 * Gestore anagrafica dei 'buckets'
 * 
 * @author m.veroni
 *
 */
public class Bucket extends Autocreate {

	private final String NAME = "s4_003_bucket";
	
	private Integer uid;
	private String uname;
	
	private Date creation;
	
	
	public Bucket() {
		super();
	}
	
	public Bucket(ConnectionManager cm, String bucketName) throws SQLException {
		this();
		selectByBacketName(cm, bucketName);		
	}
	
	
	
	private void selectByBacketName(ConnectionManager cm, String uname) throws SQLException {
		DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm);
		try {
			StringBuilder sql = new StringBuilder(50);
			sql.append("SELECT uid, uname, creation");
			sql.append(" FROM ").append(NAME);
			sql.append(" WHERE uname = '").append(uname).append("'");				
			try {
				ResultSet res = dbsu.getResultSet(sql.toString());
				if (res.next()) {
					readRow(res);
				}			
			} catch (SQLException e1) {
				checkAndCreate(dbsu, e1);
			}
			
		} finally {
			dbsu.free();
		}
	}
	
	
	
	
	
	public void save(ConnectionManager cm) throws SQLException {
		DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm);
		try {
			// Inserisco il nuovo record
			StringBuilder sql = new StringBuilder(50);
			sql.append("INSERT INTO "+NAME+ " (uname, creation)");
			sql.append(" VALUES ('").append(uname).append("', ").append(Query.toSQLDateTime(creation)).append(")");
			try {
				dbsu.execute(sql.toString());					
			} catch (SQLException e1) {
				checkAndCreate(dbsu, e1);
			}
									
		} finally {
			dbsu.free();
		}
		
		// Rifaccio la query per estrarre il progressivo
		selectByBacketName(cm, uname);		
	}
	
	
	
	
	
	private void readRow(ResultSet res) throws SQLException {
		this.uid = res.getInt("uid");
		this.uname = res.getString("uname");
		this.creation = res.getDate("creation");
	}

	
	public String getBacketName() {
		return uname;
	}
	
	public void setBacketName(String uname) {
		this.uname = uname;
	}

	
	public Integer getUid() {
		return uid;
	}

	
	public Date getCreation() {
		return creation;
	}

	public void setCreation(Date creation) {
		this.creation = creation;
	}

	
	
	@Override
	String createSQL() {
		StringBuilder sql = new StringBuilder(200);
		sql.append("CREATE TABLE ").append(NAME).append(" (");
		sql.append(" uid int(10) UNSIGNED NOT NULL AUTO_INCREMENT,");
 		sql.append(" uname varchar(250) NOT NULL,");
 		sql.append(" creation datetime NULL,");
 		sql.append(" timerecord timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,");
 		sql.append(" primary key (uid), ");
 		sql.append(" unique index iu_bucket_uname (uname)");
 		sql.append(" ) ENGINE = MyISAM");
 		sql.append(" COMMENT = 'Amazon S3 bucket list'");	
		return sql.toString();
	}


	@Override
	public String getTableName() {
		return NAME;
	}
	
	
}
