package it.softecspa.s4fs.vfat;

import it.softecspa.database.dbconnect.ConnectionManager;
import it.softecspa.database.dbconnect.DatabaseStatementUnplugged;
import it.softecspa.s4fs.S4Engine;
import it.softecspa.s4fs.S4Exception;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;

public abstract class ExpireAllocation extends Autocreate {

	Integer uid;
	
	Timestamp expire;
	boolean deleted;
	
	int delay;
	
	abstract void save(DatabaseStatementUnplugged dbsu) throws SQLException;
	
	abstract String deleteSQL();
	
	abstract boolean removeFile(FileS4 file) throws S4Exception, VFATException;
	
	abstract String selectSQLExpired();
	
	
	void delete(ConnectionManager cm) throws VFATException {
		try {
			DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm); // senza transazione
			try {
				// ---------------------------- CORE del metodo ------------------------------
				
				delete(dbsu);
			
				// ---------------------------- CORE del metodo ------------------------------
			} catch (SQLException e) {
				throw new VFATException(e);
			} finally {
				dbsu.free();
			}			
		} catch (SQLException e) {
			throw new VFATException(e);
		} catch (Exception e) {
			throw new VFATException("Unhandled exception", e);
		}
	}
	
	/**
	 * Cancella il record dalla tabella delle scadenze 
	 * @param dbsu
	 * @throws SQLException
	 */
	private void delete(DatabaseStatementUnplugged dbsu) throws SQLException {	
		// Cancello il record
		String sql = deleteSQL();
		try {
			dbsu.execute(sql);			
		} catch (SQLException e1) {
			checkAndCreate(dbsu, e1);
			dbsu.execute(sql);	
		}	
	}
	
	void deleteExpired(ConnectionManager cm) throws VFATException {
		S4Engine engine = S4Engine.getInstance();
				
		try {
			DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm); // senza transazione
			try {
				// ---------------------------- CORE del metodo ------------------------------
				String sql = selectSQLExpired();
				ResultSet res = null;
				try {
					res = dbsu.getResultSet(sql);					
				} catch (SQLException e1) {
					checkAndCreate(dbsu, e1);
					res = dbsu.getResultSet(sql);
				}
				// ...ciclo su tutti i record estratti
				while (res.next()) {
					// Pulisco al volo i file, senza rilanciare eccezioni
					// ..uso il lo stesso been per caricare i dati!
					setUid(res.getInt("uid"));
					setDeleted(res.getInt("deleted"));
					
					// Estraggo le informazioni del file dalla VFAT
					try {
						FileS4 file = engine.fileInfo(getUid(), isDeleted());
						if (file==null) {
							// Il file non esiste pi nella VFAT
							delete(dbsu);
						} else if (!file.getRealFile().exists()) {
							// Il file "reale" non esiste pi
							delete(dbsu);
						} else if (removeFile(file)) {
							// Il file  stato rimosso con successo dal filesystem
							delete(dbsu);
						}
						
						/* Controlla se il file deve essere cancellato dalla VFAT in modo definitivo
						 * - il file scaduto  solo su filesystem LOCALE
						 * - il file scaduto sta solo su Amazon S3
						 */
						terminator(file);
						
					
					} catch (VFATException e) {
						// TODO scrivere in una tabella di LOG
						log.warn(e.toString() + " deleting file file", e);
						
					} catch (S4Exception e) {
						// TODO scrivere in una tabella di LOG
						log.warn(e.toString() + " deleting file file", e);
					} catch (Exception e) {
						// TODO scrivere in una tabella di LOG
						log.warn("Unhandled exception ("+e.getClass().getSimpleName() + ") deleting file", e);
					}
				}
				
				// ---------------------------- CORE del metodo ------------------------------
			} catch (SQLException e) {
				throw new VFATException(e);
			} finally {
				dbsu.free();
			}
		} catch (SQLException e) {
			throw new VFATException(e);
		} catch (Exception e) {
			throw new VFATException("Unhandled exception", e);
		}
	}
	
	
	/**
	 * Verifica se il file ha lecondizioni per essere "terminato"
	 * ed in caso positivo lo elimina dalla VFAT
	 * @param file
	 * @throws S4Exception
	 */
	abstract void terminator(FileS4 file) throws S4Exception;
	

	void update(DatabaseStatementUnplugged dbsu) throws SQLException {
		if (getExpire()!=null) {
			save(dbsu);
		} else {
			delete(dbsu);
		}	
	}

	
	void update(ConnectionManager cm) throws VFATException {
		try {
			DatabaseStatementUnplugged dbsu = DatabaseStatementUnplugged.getInstanceAUTOCOMMIT(cm); // senza transazione
			try {
				// ---------------------------- CORE del metodo ------------------------------
				
				update(dbsu);			
			
				// ---------------------------- CORE del metodo ------------------------------
			} catch (SQLException e) {
				throw new VFATException(e);
			} finally {
				dbsu.free();
			}			
		} catch (SQLException e) {
			throw new VFATException(e);
		} catch (Exception e) {
			throw new VFATException("Unhandled exception", e);
		}
	}
	
	
	
	public Integer getUid() {
		return uid;
	}

	public void setUid(Integer fsUid) {
		this.uid = fsUid;
	}
	
	/**
	 * Restituisce la data di scadenza
	 * @return
	 */
	public Timestamp getExpire() {
		if (expire==null && delay>0) {
			Calendar now = Calendar.getInstance();
			now.add(Calendar.DAY_OF_MONTH, delay);
			expire = new Timestamp(now.getTimeInMillis());
		}
		return expire;
	}

	public void setExpire(Timestamp expire) {
		this.expire = expire;
	}


	public boolean isDeleted() {
		return deleted;
	}
	
	public void setDeleted(int delete) {
		this.deleted = (0!=delete);
	}
	
}
