package it.softecspa.s4fs.vfat;


public enum FilesystemPolicy {
	  ONLY_LOCAL	(true, false, false)    // Il file esiste solo localmente
	, ONLY_S3		(false, true, false) 	// Il file esiste solo su Amazon S3
	, S3_AND_CACHE	(true, true, true)    	// Il file esiste su Amazon S3 e in cache su tutti i filesystem che lo richiedono
	, BUFFER		(false, false, false)  	// Buffer temporaneo
	, STORAGE		(true, false, false)  	// Storage condiviso
	;  
	  
	private boolean policy[];

	private FilesystemPolicy(boolean local, boolean s3, boolean cache) {
		policy = new boolean[3];
		policy[Storage.LOCAL.index()] = local;
		policy[Storage.S3.index()] = s3;
		policy[Storage.CACHE.index()] = cache;
	}		 
	
	public boolean useLocal() {
		return policy[Storage.LOCAL.index()];
	}
	
	public boolean useS3() {
		return policy[Storage.S3.index()];
	}
	
	public boolean useCache() {
		return policy[Storage.CACHE.index()];
	}

	
	public static FilesystemPolicy rigenerate(boolean local, boolean s3, boolean cache) throws VFATException {
		if (local && s3 && cache) {
			return S3_AND_CACHE;
		}
		if (local && !(s3 && cache)) {
			return ONLY_LOCAL;
		}
		if (s3 && !(local && cache)) {
			return ONLY_S3;
		}
		if (!(s3 && local && cache)) {
			return BUFFER;
		}
		
		throw new VFATException("Not valid S4FilesystemPolicy: local = "+local +
															 " s3 = " + s3 +
															 " cache = " + cache);
		
	}

	/**
	 * Restituisce TRUE se il file risiede su filesystem non condiviso
	 * @return
	 */
	public boolean isDistributable() {
		return (this.equals(S3_AND_CACHE));		
	}
			
	
}	
